/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.resources;

import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.management.ManagementContext;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.rest.util.BrooklynRestResourceUtils;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.rest.util.json.BrooklynJacksonJsonProvider;
import brooklyn.util.guava.Maybe;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import io.brooklyn.camp.CampPlatform;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractBrooklynRestResource
implements ManagementContextInjectable {
    @Context
    ServletContext servletContext;
    private ManagementContext managementContext;
    private BrooklynRestResourceUtils brooklynRestResourceUtils;
    private ObjectMapper mapper;

    public ManagementContext mgmt() {
        return (ManagementContext)this.mgmtMaybe().get();
    }

    protected synchronized Maybe<ManagementContext> mgmtMaybe() {
        if (this.managementContext != null) {
            return Maybe.of((Object)this.managementContext);
        }
        this.managementContext = (ManagementContext)this.servletContext.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
        if (this.managementContext != null) {
            return Maybe.of((Object)this.managementContext);
        }
        return Maybe.absent((String)("ManagementContext not available for Brooklyn Jersey Resource " + this));
    }

    public void injectManagementContext(ManagementContext managementContext) {
        if (this.managementContext != null) {
            if (this.managementContext.equals(managementContext)) {
                return;
            }
            throw new IllegalStateException("ManagementContext cannot be changed: specified twice for Brooklyn Jersey Resource " + this);
        }
        this.managementContext = managementContext;
    }

    public synchronized BrooklynRestResourceUtils brooklyn() {
        if (this.brooklynRestResourceUtils != null) {
            return this.brooklynRestResourceUtils;
        }
        this.brooklynRestResourceUtils = new BrooklynRestResourceUtils(this.mgmt());
        return this.brooklynRestResourceUtils;
    }

    protected ObjectMapper mapper() {
        if (this.mapper == null) {
            this.mapper = BrooklynJacksonJsonProvider.findAnyObjectMapper(this.servletContext, this.managementContext);
        }
        return this.mapper;
    }

    @Deprecated
    protected Object getValueForDisplay(Object value, boolean preferJson, boolean isJerseyReturnValue) {
        return this.resolving(value).preferJson(preferJson).asJerseyOutermostReturnValue(isJerseyReturnValue).resolve();
    }

    protected RestValueResolver resolving(Object v) {
        return new RestValueResolver(v).mapper(this.mapper());
    }

    protected CampPlatform camp() {
        return (CampPlatform)BrooklynServerConfig.getCampPlatform((ManagementContext)this.mgmt()).get();
    }

    public static class RestValueResolver {
        private final Object valueToResolve;
        @Nullable
        private ObjectMapper mapper;
        private boolean preferJson;
        private boolean isJerseyReturnValue;
        @Nullable
        private Boolean raw;
        @Nullable
        private Entity entity;
        @Nullable
        private Duration timeout;
        @Nullable
        private Object rendererHintSource;
        private static Object UNRESOLVED = "UNRESOLVED".toCharArray();

        public static RestValueResolver resolving(Object v) {
            return new RestValueResolver(v);
        }

        private RestValueResolver(Object v) {
            this.valueToResolve = v;
        }

        public RestValueResolver mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public RestValueResolver preferJson(boolean preferJson) {
            this.preferJson = preferJson;
            return this;
        }

        public RestValueResolver asJerseyOutermostReturnValue(boolean asJerseyReturnJson) {
            this.isJerseyReturnValue = asJerseyReturnJson;
            return this;
        }

        public RestValueResolver raw(Boolean raw) {
            this.raw = raw;
            return this;
        }

        public RestValueResolver context(Entity entity) {
            this.entity = entity;
            return this;
        }

        public RestValueResolver timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public RestValueResolver renderAs(Object rendererHintSource) {
            this.rendererHintSource = rendererHintSource;
            return this;
        }

        public Object resolve() {
            Object valueResult = RestValueResolver.getImmediateValue(this.valueToResolve, this.entity);
            if (valueResult == UNRESOLVED) {
                valueResult = this.valueToResolve;
            }
            if (this.rendererHintSource != null && Boolean.FALSE.equals(this.raw)) {
                valueResult = RendererHints.applyDisplayValueHintUnchecked((Object)this.rendererHintSource, (Object)valueResult);
            }
            return WebResourceUtils.getValueForDisplay(this.mapper, valueResult, this.preferJson, this.isJerseyReturnValue);
        }

        private static Object getImmediateValue(Object value, @Nullable Entity context) {
            return Tasks.resolving((Object)value).as(Object.class).defaultValue(UNRESOLVED).timeout(Duration.ZERO).context(context).swallowExceptions().get();
        }
    }
}

