/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.filter;

import brooklyn.rest.filter.RequestTaggingFilter;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.time.Duration;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger((String)"brooklyn.REST");
    private static final Set<String> UNINTERESTING_METHODS = Sets.newHashSet((Object[])new String[]{"GET", "HEAD"});
    private static final Set<String> CENSORED_HEADERS = Sets.newHashSet((Object[])new String[]{"Authorization"});
    private static final Duration REQUEST_DURATION_LOG_POINT = Duration.FIVE_SECONDS;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String rid = RequestTaggingFilter.getTag();
        boolean isInteresting = !UNINTERESTING_METHODS.contains(httpRequest.getMethod().toUpperCase());
        boolean shouldLog = isInteresting && LOG.isDebugEnabled() || LOG.isTraceEnabled();
        boolean requestErrored = false;
        if (shouldLog) {
            String message = "Request {} starting: {} {} from {}";
            Object[] args = new Object[]{rid, httpRequest.getMethod(), httpRequest.getRequestURI(), httpRequest.getRemoteAddr()};
            if (isInteresting) {
                LOG.debug(message, args);
            } else {
                LOG.trace(message, args);
            }
        }
        Stopwatch timer = Stopwatch.createStarted();
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable e) {
            try {
                requestErrored = true;
                isInteresting = true;
                LOG.warn("Request " + rid + " (" + httpRequest.getMethod() + " " + httpRequest.getRequestURI() + " from " + httpRequest.getRemoteAddr() + ") failed: " + e, e);
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable throwable) {
                timer.stop();
                isInteresting |= timer.elapsed(TimeUnit.SECONDS) - REQUEST_DURATION_LOG_POINT.toSeconds() > 0L;
                if (shouldLog) {
                    boolean includeHeaders = requestErrored || httpResponse.getStatus() / 100 == 5 || LOG.isTraceEnabled();
                    String message = this.getRequestCompletedMessage(includeHeaders, Duration.of((Object)timer), rid, httpRequest, httpResponse);
                    if (requestErrored || isInteresting) {
                        LOG.debug(message);
                    } else {
                        LOG.trace(message);
                    }
                }
                throw throwable;
            }
        }
        timer.stop();
        isInteresting |= timer.elapsed(TimeUnit.SECONDS) - REQUEST_DURATION_LOG_POINT.toSeconds() > 0L;
        if (shouldLog) {
            boolean includeHeaders = requestErrored || httpResponse.getStatus() / 100 == 5 || LOG.isTraceEnabled();
            String message = this.getRequestCompletedMessage(includeHeaders, Duration.of((Object)timer), rid, httpRequest, httpResponse);
            if (requestErrored || isInteresting) {
                LOG.debug(message);
            } else {
                LOG.trace(message);
            }
        }
    }

    private String getRequestCompletedMessage(boolean includeHeaders, Duration elapsed, String id, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Enumeration headerNames;
        StringBuilder message = new StringBuilder("Request ").append(id).append(" completed in ").append(elapsed).append(": response ").append(httpResponse.getStatus()).append(" for ").append(httpRequest.getMethod()).append(" ").append(httpRequest.getRequestURI()).append(" from ").append(httpRequest.getRemoteAddr());
        if (!httpRequest.getParameterMap().isEmpty()) {
            message.append(", parameters: ").append(Joiner.on((String)", ").withKeyValueSeparator("=").join(httpRequest.getParameterMap()));
        }
        if (httpRequest.getContentLength() > 0) {
            int len = httpRequest.getContentLength();
            message.append(" contentType=").append(httpRequest.getContentType()).append(" (length=").append(len).append(")");
        }
        if (includeHeaders && (headerNames = httpRequest.getHeaderNames()).hasMoreElements()) {
            message.append(", headers: ");
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                message.append(headerName).append(": ");
                if (CENSORED_HEADERS.contains(headerName)) {
                    message.append("******");
                    continue;
                }
                message.append(httpRequest.getHeader(headerName));
                if (!headerNames.hasMoreElements()) continue;
                message.append(", ");
            }
        }
        return message.toString();
    }
}

