/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.filter;

import brooklyn.config.BrooklynServiceAttributes;
import brooklyn.management.ManagementContext;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.rest.domain.ApiError;
import brooklyn.rest.util.WebResourceUtils;
import brooklyn.util.text.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaMasterCheckFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HaMasterCheckFilter.class);
    public static final String SKIP_CHECK_HEADER = "Brooklyn-Allow-Non-Master-Access";
    private static final Set<String> SAFE_STANDBY_METHODS = Sets.newHashSet((Object[])new String[]{"GET", "HEAD"});
    protected ServletContext servletContext;
    protected ManagementContext mgmt;

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        this.mgmt = (ManagementContext)this.servletContext.getAttribute(BrooklynServiceAttributes.BROOKLYN_MANAGEMENT_CONTEXT);
    }

    static String lookForProblemIfServerNotRunning(ManagementContext mgmt) {
        if (mgmt == null) {
            return "no management context available";
        }
        if (!mgmt.isRunning()) {
            return "server no longer running";
        }
        if (!mgmt.isStartupComplete()) {
            return "server not in required startup-completed state";
        }
        return null;
    }

    private String lookForProblem(ServletRequest request) {
        if (this.isSkipCheckHeaderSet(request)) {
            return null;
        }
        if (!this.isMasterRequiredForRequest(request)) {
            return null;
        }
        String problem = HaMasterCheckFilter.lookForProblemIfServerNotRunning(this.mgmt);
        if (Strings.isNonBlank((CharSequence)problem)) {
            return problem;
        }
        if (!this.isMaster()) {
            return "server not in required HA master state";
        }
        return null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String problem = this.lookForProblem(request);
        if (problem != null) {
            log.warn("Disallowing web request as " + problem + ": " + request.getParameterMap() + " (caller should set '" + SKIP_CHECK_HEADER + "' to force)");
            WebResourceUtils.applyJsonResponse(this.servletContext, ApiError.builder().message("This request is only permitted against an active master Brooklyn server").errorCode(Response.Status.FORBIDDEN).build().asJsonResponse(), (HttpServletResponse)response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private boolean isMaster() {
        return ManagementNodeState.MASTER.equals((Object)this.mgmt.getHighAvailabilityManager().getNodeState());
    }

    private boolean isMasterRequiredForRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String method = httpRequest.getMethod().toUpperCase();
            if (SAFE_STANDBY_METHODS.contains(method)) {
                return false;
            }
            return !"/v1/server/shutdown".equals(httpRequest.getRequestURI());
        }
        return true;
    }

    private boolean isSkipCheckHeaderSet(ServletRequest httpRequest) {
        if (httpRequest instanceof HttpServletRequest) {
            return "true".equalsIgnoreCase(((HttpServletRequest)httpRequest).getHeader(SKIP_CHECK_HEADER));
        }
        return false;
    }
}

