/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.rest.filter;

import brooklyn.management.ManagementContext;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.rest.domain.ApiError;
import brooklyn.rest.filter.HaHotStateRequired;
import brooklyn.rest.filter.HaMasterCheckFilter;
import brooklyn.util.text.Strings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaHotCheckResourceFilter
implements ResourceFilterFactory {
    private static final Logger log = LoggerFactory.getLogger(HaHotCheckResourceFilter.class);
    private static final Set<ManagementNodeState> HOT_STATES = ImmutableSet.of((Object)ManagementNodeState.MASTER, (Object)ManagementNodeState.HOT_STANDBY, (Object)ManagementNodeState.HOT_BACKUP);
    @Context
    private ManagementContext mgmt;

    public HaHotCheckResourceFilter() {
    }

    @VisibleForTesting
    public HaHotCheckResourceFilter(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public List<ResourceFilter> create(AbstractMethod am) {
        return Collections.singletonList(new MethodFilter(am, this.mgmt));
    }

    private static class MethodFilter
    implements ResourceFilter,
    ContainerRequestFilter {
        private AbstractMethod am;
        private ManagementContext mgmt;

        public MethodFilter(AbstractMethod am, ManagementContext mgmt) {
            this.am = am;
            this.mgmt = mgmt;
        }

        public ContainerRequestFilter getRequestFilter() {
            return this;
        }

        public ContainerResponseFilter getResponseFilter() {
            return null;
        }

        private String lookForProblem(ContainerRequest request) {
            if (this.isSkipCheckHeaderSet(request)) {
                return null;
            }
            if (!this.isHaHotStateRequired(request)) {
                return null;
            }
            String problem = HaMasterCheckFilter.lookForProblemIfServerNotRunning(this.mgmt);
            if (Strings.isNonBlank((CharSequence)problem)) {
                return problem;
            }
            if (!this.isHaHotStatus()) {
                return "server not in required HA hot state";
            }
            if (this.isStateNotYetValid()) {
                return "server not yet completed loading data for required HA hot state";
            }
            return null;
        }

        public ContainerRequest filter(ContainerRequest request) {
            String problem = this.lookForProblem(request);
            if (Strings.isNonBlank((CharSequence)problem)) {
                log.warn("Disallowing web request as " + problem + ": " + request + "/" + this.am + " (caller should set '" + "Brooklyn-Allow-Non-Master-Access" + "' to force)");
                throw new WebApplicationException(ApiError.builder().message("This request is only permitted against an active hot Brooklyn server").errorCode(Response.Status.FORBIDDEN).build().asJsonResponse());
            }
            return request;
        }

        private boolean isStateNotYetValid() {
            return this.mgmt.getRebindManager().isAwaitingInitialRebind();
        }

        private boolean isHaHotStateRequired(ContainerRequest request) {
            return this.am.getAnnotation(HaHotStateRequired.class) != null || this.am.getResource().getAnnotation(HaHotStateRequired.class) != null;
        }

        private boolean isSkipCheckHeaderSet(ContainerRequest request) {
            return "true".equalsIgnoreCase(request.getHeaderValue("Brooklyn-Allow-Non-Master-Access"));
        }

        private boolean isHaHotStatus() {
            ManagementNodeState state = this.mgmt.getHighAvailabilityManager().getNodeState();
            return HOT_STATES.contains(state);
        }
    }
}

