/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.bookkeeper.clients.utils.NetUtils;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNetUtils {
    @Test
    public void testCreateEndpoint() {
        String hostname = "10.138.10.56";
        int port = 12345;
        Endpoint endpoint = NetUtils.createEndpoint((String)hostname, (int)port);
        Assert.assertEquals((Object)hostname, (Object)endpoint.getHostname());
        Assert.assertEquals((long)port, (long)endpoint.getPort());
    }

    @Test
    public void testParseEndpoint() {
        String endpointStr = "10.138.10.56:12345";
        Endpoint endpoint = NetUtils.parseEndpoint((String)endpointStr);
        Assert.assertEquals((Object)"10.138.10.56", (Object)endpoint.getHostname());
        Assert.assertEquals((long)12345L, (long)endpoint.getPort());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseInvalidEndpoint1() {
        NetUtils.parseEndpoint((String)"10.138.10.56");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseInvalidEndpoint2() {
        NetUtils.parseEndpoint((String)"10.138.10.56:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseInvalidEndpoint3() {
        NetUtils.parseEndpoint((String)"10.138.10.56:123456:123456");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseInvalidEndpointPort() {
        NetUtils.parseEndpoint((String)"10.138.10.56:abcd");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseEmptyEndpoints() {
        NetUtils.parseEndpoint((String)"");
    }

    @Test
    public void testParseEndpoints() {
        ArrayList hostnames = Lists.newArrayList((Object[])new String[]{"10.138.10.56", "10.138.10.57", "10.138.10.58"});
        ArrayList ports = Lists.newArrayList((Object[])new Integer[]{1234, 2345, 3456});
        List endpoints = IntStream.range(0, hostnames.size()).mapToObj(i -> NetUtils.createEndpoint((String)((String)hostnames.get(i)), (int)((Integer)ports.get(i)))).collect(Collectors.toList());
        String endpointStr = StringUtils.join((Collection)IntStream.range(0, hostnames.size()).mapToObj(i -> (String)hostnames.get(i) + ":" + ports.get(i)).collect(Collectors.toList()), (char)',');
        List parsedEndpoints = NetUtils.parseEndpoints((String)endpointStr);
        Assert.assertEquals(endpoints, (Object)parsedEndpoints);
    }

    @Test
    public void testToInetSocketAddress() {
        String hostname = "127.0.0.1";
        int port = 8080;
        Endpoint endpoint = NetUtils.createEndpoint((String)hostname, (int)port);
        InetSocketAddress socketAddress = new InetSocketAddress(hostname, port);
        Assert.assertEquals((Object)socketAddress, (Object)NetUtils.of((Endpoint)endpoint));
    }
}

