/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.utils.GrpcChannels;
import org.junit.Assert;
import org.junit.Test;

public class GrpcChannelsTest {
    @Test
    public void testInprocessServiceUri() {
        String serviceUri = "bk+inprocess://service";
        ManagedChannelBuilder builder = GrpcChannels.createChannelBuilder((String)serviceUri, (StorageClientSettings)StorageClientSettings.newBuilder().serviceUri(serviceUri).build());
        Assert.assertTrue((boolean)(builder instanceof InProcessChannelBuilder));
    }

    @Test
    public void testBKServiceUri() {
        String serviceUri = "bk://127.0.0.1";
        ManagedChannelBuilder builder = GrpcChannels.createChannelBuilder((String)serviceUri, (StorageClientSettings)StorageClientSettings.newBuilder().serviceUri(serviceUri).build());
        Assert.assertTrue((boolean)(builder instanceof NettyChannelBuilder));
    }

    @Test
    public void testZKServiceUri() {
        String serviceUri = "zk://127.0.0.1/stream/servers";
        try {
            GrpcChannels.createChannelBuilder((String)serviceUri, (StorageClientSettings)StorageClientSettings.newBuilder().serviceUri(serviceUri).build());
            Assert.fail((String)"Should fail to create grpc channel because `bk-grpc-name-resolver` is not in the classpath");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof ClassNotFoundException));
        }
    }
}

