/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal.api;

import com.google.common.collect.Maps;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.clients.impl.internal.api.StreamRanges;
import org.apache.bookkeeper.stream.proto.RangeKeyType;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamRanges {
    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRangeKeyType() {
        StreamRanges.ofHash((RangeKeyType)RangeKeyType.RAW, (NavigableMap)Maps.newTreeMap());
    }

    @Test
    public void testConstructor() {
        TreeMap ranges = Maps.newTreeMap();
        for (long hashKey = 0L; hashKey < 10L; ++hashKey) {
            RangeProperties props = RangeProperties.newBuilder().setStorageContainerId(hashKey).setRangeId(hashKey).setStartHashKey(hashKey).setEndHashKey(hashKey).build();
            ranges.put(hashKey, props);
        }
        HashStreamRanges hsr = StreamRanges.ofHash((RangeKeyType)RangeKeyType.HASH, (NavigableMap)ranges);
        Assert.assertEquals((Object)RangeKeyType.HASH, (Object)hsr.getKeyType());
        Assert.assertEquals((Object)ranges, (Object)hsr.getRanges());
        Assert.assertEquals((long)9L, (long)hsr.getMaxRangeId());
    }

    @Test
    public void testEqual() {
        TreeMap ranges1 = Maps.newTreeMap();
        TreeMap ranges2 = Maps.newTreeMap();
        for (long hashKey = 0L; hashKey < 10L; ++hashKey) {
            RangeProperties props1 = RangeProperties.newBuilder().setStorageContainerId(hashKey).setRangeId(hashKey).setStartHashKey(hashKey).setEndHashKey(hashKey).build();
            ranges1.put(hashKey, props1);
            RangeProperties props2 = RangeProperties.newBuilder().setStorageContainerId(hashKey).setRangeId(hashKey).setStartHashKey(hashKey).setEndHashKey(hashKey).build();
            ranges2.put(hashKey, props2);
        }
        HashStreamRanges hsr1 = StreamRanges.ofHash((RangeKeyType)RangeKeyType.HASH, (NavigableMap)ranges1);
        HashStreamRanges hsr2 = StreamRanges.ofHash((RangeKeyType)RangeKeyType.HASH, (NavigableMap)ranges2);
        Assert.assertEquals((Object)hsr1, (Object)hsr2);
    }

    @Test
    public void testNotEqual() {
        TreeMap ranges1 = Maps.newTreeMap();
        TreeMap ranges2 = Maps.newTreeMap();
        for (long hashKey = 0L; hashKey < 10L; ++hashKey) {
            RangeProperties props1 = RangeProperties.newBuilder().setStorageContainerId(hashKey).setRangeId(hashKey).setStartHashKey(hashKey).setEndHashKey(hashKey).build();
            ranges1.put(hashKey, props1);
            RangeProperties props2 = RangeProperties.newBuilder().setStorageContainerId(hashKey).setRangeId(hashKey + 1L).setStartHashKey(hashKey + 1L).setEndHashKey(hashKey + 1L).build();
            ranges2.put(hashKey, props2);
        }
        HashStreamRanges hsr1 = StreamRanges.ofHash((RangeKeyType)RangeKeyType.HASH, (NavigableMap)ranges1);
        HashStreamRanges hsr2 = StreamRanges.ofHash((RangeKeyType)RangeKeyType.HASH, (NavigableMap)ranges2);
        Assert.assertNotEquals((Object)hsr1, (Object)hsr2);
    }
}

