/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal.api;

import com.google.common.collect.Maps;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.stream.proto.RangeKeyType;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.junit.Assert;
import org.junit.Test;

public class TestHashStreamRanges {
    @Test
    public void testConstructor() {
        TreeMap ranges = Maps.newTreeMap();
        for (long hashKey = 0L; hashKey < 10L; ++hashKey) {
            RangeProperties props = RangeProperties.newBuilder().setStorageContainerId(hashKey).setRangeId(hashKey).setStartHashKey(hashKey).setEndHashKey(hashKey).build();
            ranges.put(hashKey, props);
        }
        HashStreamRanges hsr = new HashStreamRanges((NavigableMap)ranges, 9L);
        Assert.assertEquals((Object)RangeKeyType.HASH, (Object)hsr.getKeyType());
        Assert.assertEquals((Object)ranges, (Object)hsr.getRanges());
        Assert.assertEquals((long)9L, (long)hsr.getMaxRangeId());
    }
}

