/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.impl.internal.StreamMetadataCache;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStreamMetadataCache {
    private final RootRangeClient scClient = (RootRangeClient)Mockito.mock(RootRangeClient.class);
    private final StreamMetadataCache cache = new StreamMetadataCache(this.scClient);
    private final StreamProperties props = StreamProperties.newBuilder().setStorageContainerId(1234L).setStreamId(2345L).setStreamName("test-stream").setStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build();

    @Test
    public void testGetStreamProperties() throws Exception {
        Mockito.when((Object)this.scClient.getStream(ArgumentMatchers.anyLong())).thenReturn((Object)FutureUtils.value((Object)this.props));
        Assert.assertEquals((long)0L, (long)this.cache.getStreams().size());
        Assert.assertEquals((Object)this.props, (Object)FutureUtils.result((CompletableFuture)this.cache.getStreamProperties(1234L)));
        Assert.assertEquals((long)1L, (long)this.cache.getStreams().size());
        ((RootRangeClient)Mockito.verify((Object)this.scClient, (VerificationMode)Mockito.times((int)1))).getStream(ArgumentMatchers.eq((long)1234L));
    }

    @Test
    public void testPutStreamProperties() throws Exception {
        Assert.assertEquals((long)0L, (long)this.cache.getStreams().size());
        Assert.assertTrue((boolean)this.cache.putStreamProperties(1234L, this.props));
        Assert.assertEquals((long)1L, (long)this.cache.getStreams().size());
        Assert.assertFalse((boolean)this.cache.putStreamProperties(1234L, this.props));
        Assert.assertEquals((long)1L, (long)this.cache.getStreams().size());
    }
}

