/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.grpc.GrpcClientTestBase;
import org.apache.bookkeeper.clients.impl.internal.MetaRangeClientImpl;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.clients.impl.internal.api.MetaRangeClient;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.Revisioned;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.GetStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.inferred.freebuilder.shaded.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class TestStorageServerClientManagerImpl
extends GrpcClientTestBase {
    @Override
    protected void doSetup() throws Exception {
    }

    @Override
    protected void doTeardown() throws Exception {
    }

    @Test
    public void testGetMetaRangeClient() throws Exception {
        long streamId = 3456L;
        StreamProperties props = StreamProperties.newBuilder().setStorageContainerId(1234L).setStreamId(streamId).setStreamName("metaclient-stream").setStreamConf(StreamConfiguration.newBuilder().build()).build();
        MetaRangeClientImpl metaRangeClient = this.serverManager.openMetaRangeClient(props);
        Assert.assertEquals((long)1234L, (long)metaRangeClient.getStorageContainerClient().getStorageContainerId());
        Assert.assertTrue((props == metaRangeClient.getStreamProps() ? 1 : 0) != 0);
        Assert.assertEquals((Object)props, (Object)FutureUtils.result((CompletableFuture)this.serverManager.getStreamProperties(streamId)));
        Assert.assertEquals((Object)metaRangeClient, (Object)FutureUtils.result((CompletableFuture)this.serverManager.openMetaRangeClient(streamId)));
    }

    @Test
    public void testGetMetaRangeClientByStreamId() throws Exception {
        long streamId = 3456L;
        final StreamProperties props = StreamProperties.newBuilder().setStorageContainerId(1234L).setStreamId(streamId).setStreamName("metaclient-stream").setStreamConf(StreamConfiguration.newBuilder().build()).build();
        RootRangeServiceGrpc.RootRangeServiceImplBase rootRangeService = new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getStream(GetStreamRequest request, StreamObserver<GetStreamResponse> responseObserver) {
                responseObserver.onNext((Object)GetStreamResponse.newBuilder().setCode(StatusCode.SUCCESS).setStreamProps(props).build());
                responseObserver.onCompleted();
            }
        };
        this.serviceRegistry.addService(rootRangeService.bindService());
        Assert.assertEquals((Object)props, (Object)FutureUtils.result((CompletableFuture)this.serverManager.getStreamProperties(streamId)));
        MetaRangeClient client = (MetaRangeClient)FutureUtils.result((CompletableFuture)this.serverManager.openMetaRangeClient(streamId));
        Assert.assertEquals((Object)props, (Object)client.getStreamProps());
    }

    @Test
    public void testGetLocationClient() throws Exception {
        LocationClient lc = this.serverManager.getLocationClient();
        Assert.assertNotNull((Object)lc);
        Assert.assertEquals((Object)lc, (Object)this.serverManager.getLocationClient());
        List responses = (List)FutureUtils.result((CompletableFuture)lc.locateStorageContainers((List)Lists.newArrayList((Object[])new Revisioned[]{Revisioned.of((Object)123L, (long)456L)})));
        Assert.assertEquals((long)1L, (long)responses.size());
        Assert.assertEquals((Object)StatusCode.SUCCESS, (Object)((OneStorageContainerEndpointResponse)responses.get(0)).getStatusCode());
        Assert.assertEquals((Object)ENDPOINT, (Object)((OneStorageContainerEndpointResponse)responses.get(0)).getEndpoint().getRwEndpoint());
        Assert.assertEquals((long)0L, (long)((OneStorageContainerEndpointResponse)responses.get(0)).getEndpoint().getRoEndpointCount());
    }
}

