/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImplTestBase;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.GetStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.junit.Assert;

public class TestRootRangeClientGetStreamByIdRpc
extends RootRangeClientImplTestBase {
    private long streamId;
    private StreamProperties streamProps;

    @Override
    protected void doSetup() throws Exception {
        super.doSetup();
        this.streamId = System.currentTimeMillis();
        String streamName = this.testName.getMethodName() + "_stream";
        this.streamProps = StreamProperties.newBuilder().setStorageContainerId(System.currentTimeMillis()).setStreamId(this.streamId).setStreamName(streamName).setStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build();
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForSuccess() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getStream(GetStreamRequest request, StreamObserver<GetStreamResponse> responseObserver) {
                responseObserver.onNext((Object)GetStreamResponse.newBuilder().setCode(StatusCode.SUCCESS).setStreamProps(TestRootRangeClientGetStreamByIdRpc.this.streamProps).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifySuccess(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getStream(this.streamId);
        Assert.assertTrue((this.streamProps == getFuture.get() ? 1 : 0) != 0);
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRequestFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getStream(GetStreamRequest request, StreamObserver<GetStreamResponse> responseObserver) {
                responseObserver.onNext((Object)GetStreamResponse.newBuilder().setCode(StatusCode.STREAM_NOT_FOUND).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifyRequestFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getStream(this.streamId);
        try {
            getFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StreamNotFoundException));
        }
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRpcFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getStream(GetStreamRequest request, StreamObserver<GetStreamResponse> responseObserver) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL));
            }
        };
    }

    @Override
    protected void verifyRpcFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getStream(this.streamId);
        try {
            getFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StatusRuntimeException));
            StatusRuntimeException se = (StatusRuntimeException)ee.getCause();
            Assert.assertEquals((Object)Status.INTERNAL, (Object)se.getStatus());
        }
    }

    @Override
    protected void verifyChannelFailure(IOException expectedException, RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getStream(this.streamId);
        try {
            getFuture.get();
            Assert.fail((String)"Should fail on creating stream");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof ClientException));
            ClientException zse = (ClientException)ee.getCause();
            Assert.assertNotNull((Object)zse.getCause());
            Assert.assertTrue((expectedException == zse.getCause() ? 1 : 0) != 0);
        }
    }
}

