/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImplTestBase;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.junit.Assert;

public class TestRootRangeClientGetNamespaceRpc
extends RootRangeClientImplTestBase {
    private long colId;
    private String colName;
    private NamespaceProperties colProps;
    private static final NamespaceConfiguration colConf = NamespaceConfiguration.newBuilder().setDefaultStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build();

    @Override
    protected void doSetup() throws Exception {
        super.doSetup();
        this.colId = System.currentTimeMillis();
        this.colName = this.testName.getMethodName();
        this.colProps = NamespaceProperties.newBuilder().setNamespaceId(this.colId).setNamespaceName(this.colName).setDefaultStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build();
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForSuccess() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getNamespace(GetNamespaceRequest request, StreamObserver<GetNamespaceResponse> responseObserver) {
                responseObserver.onNext((Object)GetNamespaceResponse.newBuilder().setCode(StatusCode.SUCCESS).setNsProps(TestRootRangeClientGetNamespaceRpc.this.colProps).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifySuccess(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getNamespace(this.colName);
        Assert.assertTrue((this.colProps == getFuture.get() ? 1 : 0) != 0);
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRequestFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getNamespace(GetNamespaceRequest request, StreamObserver<GetNamespaceResponse> responseObserver) {
                responseObserver.onNext((Object)GetNamespaceResponse.newBuilder().setCode(StatusCode.NAMESPACE_NOT_FOUND).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifyRequestFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getNamespace(this.colName);
        try {
            getFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof NamespaceNotFoundException));
        }
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRpcFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void getNamespace(GetNamespaceRequest request, StreamObserver<GetNamespaceResponse> responseObserver) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL));
            }
        };
    }

    @Override
    protected void verifyRpcFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture getFuture = rootRangeClient.getNamespace(this.colName);
        try {
            getFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StatusRuntimeException));
            StatusRuntimeException se = (StatusRuntimeException)ee.getCause();
            Assert.assertEquals((Object)Status.INTERNAL, (Object)se.getStatus());
        }
    }

    @Override
    protected void verifyChannelFailure(IOException expectedException, RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture createFuture = rootRangeClient.createNamespace(this.colName, colConf);
        try {
            createFuture.get();
            Assert.fail((String)"Should fail on creating stream");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof ClientException));
            ClientException zse = (ClientException)ee.getCause();
            Assert.assertNotNull((Object)zse.getCause());
            Assert.assertTrue((expectedException == zse.getCause() ? 1 : 0) != 0);
        }
    }
}

