/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImplTestBase;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.junit.Assert;

public class TestRootRangeClientDeleteStreamRpc
extends RootRangeClientImplTestBase {
    private String colName;
    private String streamName;

    @Override
    protected void doSetup() throws Exception {
        super.doSetup();
        this.colName = this.testName.getMethodName() + "_col";
        this.streamName = this.testName.getMethodName() + "_col";
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForSuccess() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void deleteStream(DeleteStreamRequest request, StreamObserver<DeleteStreamResponse> responseObserver) {
                responseObserver.onNext((Object)DeleteStreamResponse.newBuilder().setCode(StatusCode.SUCCESS).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifySuccess(RootRangeClient rootRangeClient) throws Exception {
        Assert.assertTrue((boolean)((Boolean)rootRangeClient.deleteStream(this.colName, this.streamName).get()));
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRequestFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void deleteStream(DeleteStreamRequest request, StreamObserver<DeleteStreamResponse> responseObserver) {
                responseObserver.onNext((Object)DeleteStreamResponse.newBuilder().setCode(StatusCode.STREAM_NOT_FOUND).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifyRequestFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture deleteFuture = rootRangeClient.deleteStream(this.colName, this.streamName);
        try {
            deleteFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StreamNotFoundException));
        }
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRpcFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void deleteStream(DeleteStreamRequest request, StreamObserver<DeleteStreamResponse> responseObserver) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL));
            }
        };
    }

    @Override
    protected void verifyRpcFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture deleteFuture = rootRangeClient.deleteStream(this.colName, this.streamName);
        try {
            deleteFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StatusRuntimeException));
            StatusRuntimeException se = (StatusRuntimeException)ee.getCause();
            Assert.assertEquals((Object)Status.INTERNAL, (Object)se.getStatus());
        }
    }

    @Override
    protected void verifyChannelFailure(IOException expectedException, RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture deleteFuture = rootRangeClient.deleteStream(this.colName, this.streamName);
        try {
            deleteFuture.get();
            Assert.fail((String)"Should fail on rpc operation");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof ClientException));
            ClientException zse = (ClientException)ee.getCause();
            Assert.assertNotNull((Object)zse.getCause());
            Assert.assertTrue((expectedException == zse.getCause() ? 1 : 0) != 0);
        }
    }
}

