/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImplTestBase;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.junit.Assert;

public class TestRootRangeClientCreateStreamRpc
extends RootRangeClientImplTestBase {
    private long streamId;
    private String colName;
    private String streamName;
    private StreamProperties streamProps;
    private static final StreamConfiguration streamConf = ProtocolConstants.DEFAULT_STREAM_CONF;

    @Override
    protected void doSetup() throws Exception {
        super.doSetup();
        this.streamId = System.currentTimeMillis();
        this.colName = this.testName.getMethodName() + "_col";
        this.streamName = this.testName.getMethodName() + "_stream";
        this.streamProps = StreamProperties.newBuilder().setStorageContainerId(System.currentTimeMillis()).setStreamId(this.streamId).setStreamName(this.streamName).setStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build();
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForSuccess() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void createStream(CreateStreamRequest request, StreamObserver<CreateStreamResponse> responseObserver) {
                responseObserver.onNext((Object)CreateStreamResponse.newBuilder().setCode(StatusCode.SUCCESS).setStreamProps(TestRootRangeClientCreateStreamRpc.this.streamProps).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifySuccess(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture createFuture = rootRangeClient.createStream(this.colName, this.streamName, streamConf);
        Assert.assertTrue((this.streamProps == createFuture.get() ? 1 : 0) != 0);
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRequestFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void createStream(CreateStreamRequest request, StreamObserver<CreateStreamResponse> responseObserver) {
                responseObserver.onNext((Object)CreateStreamResponse.newBuilder().setCode(StatusCode.STREAM_NOT_FOUND).build());
                responseObserver.onCompleted();
            }
        };
    }

    @Override
    protected void verifyRequestFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture createFuture = rootRangeClient.createStream(this.colName, this.streamName, streamConf);
        try {
            createFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StreamNotFoundException));
        }
    }

    @Override
    protected RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRpcFailure() {
        return new RootRangeServiceGrpc.RootRangeServiceImplBase(){

            public void createStream(CreateStreamRequest request, StreamObserver<CreateStreamResponse> responseObserver) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL));
            }
        };
    }

    @Override
    protected void verifyRpcFailure(RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture createFuture = rootRangeClient.createStream(this.colName, this.streamName, streamConf);
        try {
            createFuture.get();
            Assert.fail((String)"Should fail on rpc failure");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StatusRuntimeException));
            StatusRuntimeException se = (StatusRuntimeException)ee.getCause();
            Assert.assertEquals((Object)Status.INTERNAL, (Object)se.getStatus());
        }
    }

    @Override
    protected void verifyChannelFailure(IOException expectedException, RootRangeClient rootRangeClient) throws Exception {
        CompletableFuture createFuture = rootRangeClient.createStream(this.colName, this.streamName, streamConf);
        try {
            createFuture.get();
            Assert.fail((String)"Should fail on creating stream");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof ClientException));
            ClientException zse = (ClientException)ee.getCause();
            Assert.assertNotNull((Object)zse.getCause());
            Assert.assertTrue((expectedException == zse.getCause() ? 1 : 0) != 0);
        }
    }
}

