/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.InvalidNamespaceNameException;
import org.apache.bookkeeper.clients.exceptions.InvalidStreamNameException;
import org.apache.bookkeeper.clients.exceptions.NamespaceExistsException;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StreamExistsException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.common.util.Revisioned;
import org.apache.bookkeeper.stream.proto.RangeKeyType;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesResponse;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.RelatedRanges;
import org.apache.bookkeeper.stream.proto.storage.RelationType;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerEndpoint;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestProtocolInternalUtils {
    @Rule
    public final TestName name = new TestName();

    @Test
    public void testCreateActiveRanges() {
        GetActiveRangesResponse.Builder responseBuilder = GetActiveRangesResponse.newBuilder();
        responseBuilder.addRanges(RelatedRanges.newBuilder().setProps(RangeProperties.newBuilder().setStartHashKey(Long.MIN_VALUE).setEndHashKey(0L).setRangeId(1L).setStorageContainerId(1L)).setType(RelationType.PARENTS).addRelatedRanges(-1L)).addRanges(RelatedRanges.newBuilder().setProps(RangeProperties.newBuilder().setStartHashKey(0L).setEndHashKey(Long.MAX_VALUE).setRangeId(2L).setStorageContainerId(2L)).setType(RelationType.PARENTS).addRelatedRanges(-1L));
        GetActiveRangesResponse response = responseBuilder.build();
        HashStreamRanges hsr = ProtocolInternalUtils.createActiveRanges((GetActiveRangesResponse)response);
        TreeMap activeRanges = Maps.newTreeMap();
        activeRanges.put(Long.MIN_VALUE, response.getRanges(0).getProps());
        activeRanges.put(0L, response.getRanges(1).getProps());
        HashStreamRanges expectedHSR = HashStreamRanges.ofHash((RangeKeyType)RangeKeyType.HASH, (NavigableMap)activeRanges);
        Assert.assertEquals((Object)expectedHSR, (Object)hsr);
        Assert.assertEquals((long)2L, (long)hsr.getMaxRangeId());
    }

    @Test
    public void testCreateActiveRangesInvalidKeyRange() {
        GetActiveRangesResponse.Builder responseBuilder = GetActiveRangesResponse.newBuilder();
        responseBuilder.addRanges(RelatedRanges.newBuilder().setProps(RangeProperties.newBuilder().setStartHashKey(Long.MIN_VALUE).setEndHashKey(0L).setRangeId(1L).setStorageContainerId(1L)).setType(RelationType.PARENTS).addRelatedRanges(-1L)).addRanges(RelatedRanges.newBuilder().setProps(RangeProperties.newBuilder().setStartHashKey(1L).setEndHashKey(Long.MAX_VALUE).setRangeId(2L).setStorageContainerId(2L)).setType(RelationType.PARENTS).addRelatedRanges(-1L));
        try {
            ProtocolInternalUtils.createActiveRanges((GetActiveRangesResponse)responseBuilder.build());
            Assert.fail((String)"Should fail with invalid key range");
        }
        catch (IllegalStateException ise) {
            Assert.assertEquals((Object)String.format("Invalid range key found : expected = %d, actual = %d", 0L, 1L), (Object)ise.getMessage());
        }
    }

    @Test
    public void testCreateActiveRangesMissingKeyRange() {
        GetActiveRangesResponse.Builder responseBuilder = GetActiveRangesResponse.newBuilder();
        responseBuilder.addRanges(RelatedRanges.newBuilder().setProps(RangeProperties.newBuilder().setStartHashKey(Long.MIN_VALUE).setEndHashKey(0L).setRangeId(1L).setStorageContainerId(1L)).setType(RelationType.PARENTS).addRelatedRanges(-1L)).addRanges(RelatedRanges.newBuilder().setProps(RangeProperties.newBuilder().setStartHashKey(0L).setEndHashKey(1234L).setRangeId(2L).setStorageContainerId(2L)).setType(RelationType.PARENTS).addRelatedRanges(-1L));
        try {
            ProtocolInternalUtils.createActiveRanges((GetActiveRangesResponse)responseBuilder.build());
            Assert.fail((String)"Should fail with missing key range");
        }
        catch (IllegalStateException ise) {
            Assert.assertEquals((Object)String.format("Missing key range [%d - %d)", 1234L, Long.MAX_VALUE), (Object)ise.getMessage());
        }
    }

    @Test
    public void testCreateGetStorageContainerEndpointRequest() {
        ArrayList scs = Lists.newArrayList((Object[])new Revisioned[]{Revisioned.of((Object)1000L, (long)1L), Revisioned.of((Object)2000L, (long)2L), Revisioned.of((Object)3000L, (long)3L)});
        GetStorageContainerEndpointRequest request = ProtoUtils.createGetStorageContainerEndpointRequest((List)scs);
        Assert.assertEquals((long)3L, (long)request.getRequestsCount());
        int i = 1;
        for (OneStorageContainerEndpointRequest oneRequest : request.getRequestsList()) {
            Assert.assertEquals((long)(1000L * (long)i), (long)oneRequest.getStorageContainer());
            Assert.assertEquals((long)(1L * (long)i), (long)oneRequest.getRevision());
            ++i;
        }
    }

    @Test
    public void testCreateStorageContainerEndpointResponse() {
        ArrayList endpoints = Lists.newArrayList((Object[])new StorageContainerEndpoint[]{StorageContainerEndpoint.newBuilder().setStorageContainerId(1L).build(), StorageContainerEndpoint.newBuilder().setStorageContainerId(2L).build(), StorageContainerEndpoint.newBuilder().setStorageContainerId(3L).build()});
        GetStorageContainerEndpointResponse response = ProtoUtils.createGetStorageContainerEndpointResponse((List)endpoints);
        Assert.assertEquals((long)3L, (long)response.getResponsesCount());
        int i = 0;
        for (OneStorageContainerEndpointResponse oneResp : response.getResponsesList()) {
            Assert.assertEquals((Object)StatusCode.SUCCESS, (Object)oneResp.getStatusCode());
            Assert.assertTrue((endpoints.get(i) == oneResp.getEndpoint() ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testCreateRootRangeException() {
        String name = "test-create-root-range-exception";
        Throwable cause1 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.STREAM_EXISTS);
        Assert.assertTrue((boolean)(cause1 instanceof StreamExistsException));
        StreamExistsException see = (StreamExistsException)cause1;
        Throwable cause2 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.STREAM_NOT_FOUND);
        Assert.assertTrue((boolean)(cause2 instanceof StreamNotFoundException));
        StreamNotFoundException snfe = (StreamNotFoundException)cause2;
        Throwable invalidStreamNameCause = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.INVALID_STREAM_NAME);
        Assert.assertTrue((boolean)(invalidStreamNameCause instanceof InvalidStreamNameException));
        InvalidStreamNameException isne = (InvalidStreamNameException)invalidStreamNameCause;
        Throwable cause3 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.FAILURE);
        ClientException se = (ClientException)cause3;
        Assert.assertEquals((Object)("fail to access its root range : code = " + StatusCode.FAILURE), (Object)se.getMessage());
        Throwable cause5 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.NAMESPACE_EXISTS);
        Assert.assertTrue((boolean)(cause5 instanceof NamespaceExistsException));
        Throwable cause6 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.NAMESPACE_NOT_FOUND);
        Assert.assertTrue((boolean)(cause6 instanceof NamespaceNotFoundException));
        Throwable cause7 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.INVALID_NAMESPACE_NAME);
        Assert.assertTrue((boolean)(cause7 instanceof InvalidNamespaceNameException));
    }

    @Test
    public void testMetaRangeException() {
        String name = "test-meta-range-exception";
        Exception existCause = ProtocolInternalUtils.createMetaRangeException((String)name, (StatusCode)StatusCode.STREAM_EXISTS);
        Assert.assertTrue((boolean)(existCause instanceof StreamExistsException));
        Exception notFoundCause = ProtocolInternalUtils.createMetaRangeException((String)name, (StatusCode)StatusCode.STREAM_NOT_FOUND);
        Assert.assertTrue((boolean)(notFoundCause instanceof StreamNotFoundException));
    }
}

