/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.collect.Lists;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.clients.grpc.GrpcClientTestBase;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannelManager;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelManager;
import org.apache.bookkeeper.clients.impl.internal.MetaRangeClientImpl;
import org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesRequest;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesResponse;
import org.apache.bookkeeper.stream.proto.storage.MetaRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.RelatedRanges;
import org.apache.bookkeeper.stream.proto.storage.RelationType;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMetaRangeClientImpl
extends GrpcClientTestBase {
    private static final long streamId = 1234L;
    private static final long groupId = 456L;
    private static final StreamProperties streamProps = StreamProperties.newBuilder().setStreamId(1234L).setStorageContainerId(456L).setStreamName("test-meta-range-client").setStreamConf(StreamConfiguration.newBuilder().build()).build();
    private final LocationClient locationClient = (LocationClient)Mockito.mock(LocationClient.class);
    private MetaRangeClientImpl metaRangeClient;
    private final StorageServerChannel rsChannel = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    private final StorageServerChannelManager channelManager = new StorageServerChannelManager(ep -> this.rsChannel);

    @Override
    protected void doSetup() throws Exception {
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test-meta-range-client").build();
        this.metaRangeClient = new MetaRangeClientImpl(streamProps, this.scheduler, new StorageContainerChannelManager(this.channelManager, this.locationClient, this.scheduler));
    }

    @Override
    protected void doTeardown() throws Exception {
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    private RelatedRanges buildRelatedRange(long startKey, long endKey, long rangeId, long groupId, List<Long> parentRanges) {
        return RelatedRanges.newBuilder().setProps(this.buildRangeMeta(startKey, endKey, rangeId, groupId)).setType(RelationType.PARENTS).addAllRelatedRanges(parentRanges).build();
    }

    private RangeProperties buildRangeMeta(long startKey, long endKey, long rangeId, long groupId) {
        return RangeProperties.newBuilder().setStartHashKey(startKey).setEndHashKey(endKey).setRangeId(rangeId).setStorageContainerId(groupId).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetActiveStreamRanges() throws Exception {
        CompletableFuture serviceFuture = FutureUtils.createFuture();
        this.metaRangeClient.getStorageContainerClient().setStorageServerChannelFuture(serviceFuture);
        final GetActiveRangesResponse getActiveRangesResponse = GetActiveRangesResponse.newBuilder().setCode(StatusCode.SUCCESS).addRanges(this.buildRelatedRange(Long.MIN_VALUE, 0L, 123L, 1L, Lists.newArrayList((Object[])new Long[]{113L}))).addRanges(this.buildRelatedRange(0L, Long.MAX_VALUE, 124L, 2L, Lists.newArrayList((Object[])new Long[]{114L}))).build();
        MetaRangeServiceGrpc.MetaRangeServiceImplBase metaRangeService = new MetaRangeServiceGrpc.MetaRangeServiceImplBase(){

            public void getActiveRanges(GetActiveRangesRequest request, StreamObserver<GetActiveRangesResponse> responseObserver) {
                responseObserver.onNext((Object)getActiveRangesResponse);
                responseObserver.onCompleted();
            }
        };
        this.serviceRegistry.addService(metaRangeService.bindService());
        StorageServerChannel rsChannel = new StorageServerChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build(), Optional.empty());
        try {
            serviceFuture.complete(rsChannel);
            HashStreamRanges expectedStream = ProtocolInternalUtils.createActiveRanges((GetActiveRangesResponse)getActiveRangesResponse);
            CompletableFuture getFuture = this.metaRangeClient.getActiveDataRanges();
            Assert.assertEquals((Object)expectedStream, getFuture.get());
        }
        finally {
            if (Collections.singletonList(rsChannel).get(0) != null) {
                rsChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetActiveStreamRangesFailure() throws Exception {
        CompletableFuture serviceFuture = FutureUtils.createFuture();
        this.metaRangeClient.getStorageContainerClient().setStorageServerChannelFuture(serviceFuture);
        MetaRangeServiceGrpc.MetaRangeServiceImplBase metaRangeService = new MetaRangeServiceGrpc.MetaRangeServiceImplBase(){

            public void getActiveRanges(GetActiveRangesRequest request, StreamObserver<GetActiveRangesResponse> responseObserver) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL));
            }
        };
        this.serviceRegistry.addService(metaRangeService.bindService());
        StorageServerChannel rsChannel = new StorageServerChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build(), Optional.empty());
        try {
            serviceFuture.complete(rsChannel);
            CompletableFuture getFuture = this.metaRangeClient.getActiveDataRanges();
            try {
                getFuture.get();
                Assert.fail((String)"should fail on rpc failure");
            }
            catch (ExecutionException ee) {
                Assert.assertNotNull((Object)ee.getCause());
                Assert.assertTrue((boolean)(ee.getCause() instanceof StatusRuntimeException));
                StatusRuntimeException se = (StatusRuntimeException)ee.getCause();
                Assert.assertEquals((Object)Status.INTERNAL, (Object)se.getStatus());
            }
        }
        finally {
            if (Collections.singletonList(rsChannel).get(0) != null) {
                rsChannel.close();
            }
        }
    }
}

