/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.collect.Lists;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.StorageContainerException;
import org.apache.bookkeeper.clients.grpc.GrpcClientTestBase;
import org.apache.bookkeeper.clients.impl.internal.LocationClientImpl;
import org.apache.bookkeeper.clients.utils.NetUtils;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.Revisioned;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerEndpoint;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerServiceGrpc;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLocationClientImpl
extends GrpcClientTestBase {
    private static final Logger log = LoggerFactory.getLogger(TestLocationClientImpl.class);
    private LocationClientImpl locationClient;
    private final List<StorageContainerEndpoint> endpoints = IntStream.range(0, 10).boxed().map(i -> TestLocationClientImpl.createEndpoint(i)).collect(Collectors.toList());
    private final StorageContainerServiceGrpc.StorageContainerServiceImplBase locationService = new StorageContainerServiceGrpc.StorageContainerServiceImplBase(){

        public void getStorageContainerEndpoint(GetStorageContainerEndpointRequest request, StreamObserver<GetStorageContainerEndpointResponse> responseObserver) {
            GetStorageContainerEndpointResponse.Builder respBuilder = GetStorageContainerEndpointResponse.newBuilder();
            if (0 == request.getRequestsCount()) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.INVALID_ARGUMENT));
            } else {
                for (OneStorageContainerEndpointRequest oneRequest : request.getRequestsList()) {
                    respBuilder.addResponses(this.processOneStorageContainerEndpointRequest(oneRequest));
                }
                respBuilder.setStatusCode(StatusCode.SUCCESS);
                responseObserver.onNext((Object)respBuilder.build());
            }
            responseObserver.onCompleted();
        }

        OneStorageContainerEndpointResponse.Builder processOneStorageContainerEndpointRequest(OneStorageContainerEndpointRequest request) {
            StatusCode code;
            StorageContainerEndpoint endpoint = null;
            if (request.getStorageContainer() < 0L) {
                code = StatusCode.INVALID_GROUP_ID;
            } else if (request.getStorageContainer() >= (long)TestLocationClientImpl.this.endpoints.size()) {
                code = StatusCode.GROUP_NOT_FOUND;
            } else {
                code = StatusCode.SUCCESS;
                endpoint = (StorageContainerEndpoint)TestLocationClientImpl.this.endpoints.get((int)request.getStorageContainer());
            }
            if (endpoint != null && endpoint.getRevision() <= request.getRevision()) {
                code = StatusCode.STALE_GROUP_INFO;
                endpoint = null;
            }
            OneStorageContainerEndpointResponse.Builder builder = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(code);
            if (null != endpoint) {
                builder = builder.setEndpoint(endpoint);
            }
            return builder;
        }
    };
    private ServerServiceDefinition locationServiceDefinition;

    private static StorageContainerEndpoint createEndpoint(int groupId) {
        return StorageContainerEndpoint.newBuilder().setStorageContainerId((long)groupId).setRevision(1000L + (long)groupId).setRwEndpoint(NetUtils.createEndpoint((String)("127.0.0." + groupId), (int)groupId)).addRoEndpoint(NetUtils.createEndpoint((String)("128.0.0." + groupId), (int)groupId)).build();
    }

    @Override
    protected void doSetup() throws Exception {
        StorageClientSettings settings = StorageClientSettings.newBuilder().serviceUri("bk+inprocess://" + this.serverName).build();
        this.locationClient = new LocationClientImpl(settings, this.scheduler);
        this.locationServiceDefinition = this.locationService.bindService();
        this.serviceRegistry.addService(this.locationServiceDefinition);
    }

    @Override
    protected void doTeardown() throws Exception {
        if (null != this.locationClient) {
            this.locationClient.close();
        }
    }

    private void assertOneStorageContainerEndpointResponse(OneStorageContainerEndpointResponse response, StatusCode expectedStatusCode, StorageContainerEndpoint expectedEndpoint) {
        Assert.assertEquals((Object)expectedStatusCode, (Object)response.getStatusCode());
        if (null != expectedEndpoint) {
            Assert.assertEquals((String)("Expected endpoint = " + expectedEndpoint + ", Actual endpoint = " + response.getEndpoint()), (Object)expectedEndpoint, (Object)response.getEndpoint());
        } else {
            Assert.assertFalse((boolean)response.hasEndpoint());
        }
    }

    @Test
    public void testLocateStorageContainersSuccess() throws Exception {
        CompletableFuture future = this.locationClient.locateStorageContainers((List)Lists.newArrayList((Object[])new Revisioned[]{Revisioned.of((Object)1L, (long)-1L), Revisioned.of((Object)3L, (long)-1L), Revisioned.of((Object)5L, (long)-1L), Revisioned.of((Object)7L, (long)-1L)}));
        List result = (List)FutureUtils.result((CompletableFuture)future);
        Assert.assertEquals((long)4L, (long)result.size());
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(0), StatusCode.SUCCESS, this.endpoints.get(1));
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(1), StatusCode.SUCCESS, this.endpoints.get(3));
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(2), StatusCode.SUCCESS, this.endpoints.get(5));
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(3), StatusCode.SUCCESS, this.endpoints.get(7));
    }

    @Test
    public void testLocateStorageContainersInvalidArgs() throws Exception {
        CompletableFuture future = this.locationClient.locateStorageContainers((List)Lists.newArrayList());
        try {
            future.get();
            Assert.fail((String)"Should fail with invalid arguments");
        }
        catch (ExecutionException ee) {
            Throwable cause = ee.getCause();
            Assert.assertTrue((String)("Unexpected exception : " + cause), (boolean)(cause instanceof StatusRuntimeException));
            Assert.assertEquals((Object)Status.INVALID_ARGUMENT, (Object)((StatusRuntimeException)cause).getStatus());
        }
    }

    @Test
    public void testLocateStorageContainersFailures() throws Exception {
        CompletableFuture future = this.locationClient.locateStorageContainers((List)Lists.newArrayList((Object[])new Revisioned[]{Revisioned.of((Object)-1L, (long)-1L), Revisioned.of((Object)1L, (long)-1L), Revisioned.of((Object)3L, (long)Long.MAX_VALUE), Revisioned.of((Object)Long.MAX_VALUE, (long)-1L)}));
        List result = (List)FutureUtils.result((CompletableFuture)future);
        Assert.assertEquals((long)4L, (long)result.size());
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(0), StatusCode.INVALID_GROUP_ID, null);
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(1), StatusCode.SUCCESS, this.endpoints.get(1));
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(2), StatusCode.STALE_GROUP_INFO, null);
        this.assertOneStorageContainerEndpointResponse((OneStorageContainerEndpointResponse)result.get(3), StatusCode.GROUP_NOT_FOUND, null);
    }

    @Test
    public void testLocateStorageContainersRetryPredicate() throws Exception {
        Assert.assertTrue((boolean)LocationClientImpl.LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE.test(new StatusException(Status.INTERNAL)));
        Assert.assertTrue((boolean)LocationClientImpl.LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE.test(new StatusRuntimeException(Status.INTERNAL)));
        Assert.assertFalse((boolean)LocationClientImpl.LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE.test(new StatusException(Status.INVALID_ARGUMENT)));
        Assert.assertFalse((boolean)LocationClientImpl.LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE.test(new StatusRuntimeException(Status.INVALID_ARGUMENT)));
        Assert.assertTrue((boolean)LocationClientImpl.LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE.test(new ClientException("test-2")));
        Assert.assertTrue((boolean)LocationClientImpl.LOCATE_STORAGE_CONTAINERS_RETRY_PREDICATE.test(new StorageContainerException(StatusCode.FAILURE, "test-3")));
    }

    @Test
    public void testLocateStorageContainersSucceedAfterRetried() throws Exception {
        this.serviceRegistry.removeService(this.locationServiceDefinition);
        final AtomicInteger retries = new AtomicInteger(3);
        final StatusRuntimeException statusException = new StatusRuntimeException(Status.INTERNAL);
        StorageContainerServiceGrpc.StorageContainerServiceImplBase locationServiceWithFailures = new StorageContainerServiceGrpc.StorageContainerServiceImplBase(){

            public void getStorageContainerEndpoint(GetStorageContainerEndpointRequest request, StreamObserver<GetStorageContainerEndpointResponse> responseObserver) {
                if (retries.decrementAndGet() == 0) {
                    TestLocationClientImpl.this.locationService.getStorageContainerEndpoint(request, responseObserver);
                    return;
                }
                responseObserver.onError((Throwable)statusException);
            }
        };
        this.serviceRegistry.addService(locationServiceWithFailures.bindService());
        this.testLocateStorageContainersSuccess();
        Assert.assertEquals((long)0L, (long)retries.get());
    }

    @Test
    public void testLocateStorageContainersFailureAfterRetried() throws Exception {
        this.serviceRegistry.removeService(this.locationServiceDefinition);
        final AtomicInteger retries = new AtomicInteger(3);
        final StatusRuntimeException statusException = new StatusRuntimeException(Status.INTERNAL);
        StorageContainerServiceGrpc.StorageContainerServiceImplBase locationServiceWithFailures = new StorageContainerServiceGrpc.StorageContainerServiceImplBase(){

            public void getStorageContainerEndpoint(GetStorageContainerEndpointRequest request, StreamObserver<GetStorageContainerEndpointResponse> responseObserver) {
                if (retries.decrementAndGet() == 0) {
                    responseObserver.onError((Throwable)new StatusRuntimeException(Status.INVALID_ARGUMENT));
                    return;
                }
                responseObserver.onError((Throwable)statusException);
            }
        };
        this.serviceRegistry.addService(locationServiceWithFailures.bindService());
        CompletableFuture future = this.locationClient.locateStorageContainers((List)Lists.newArrayList((Object[])new Revisioned[]{Revisioned.of((Object)1L, (long)-1L)}));
        try {
            future.get();
            Assert.fail((String)"should fail with exception");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof StatusRuntimeException));
            Assert.assertEquals((Object)Status.INVALID_ARGUMENT, (Object)((StatusRuntimeException)ee.getCause()).getStatus());
        }
        Assert.assertEquals((long)0L, (long)retries.get());
    }
}

