/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImplWithRetries;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class RootRangeClientImplWithRetriesTest {
    private static final int NUM_RETRIES = 3;
    private static final String NS_NAME = "test-namespace";
    private static final NamespaceConfiguration NS_CONF = NamespaceConfiguration.newBuilder().build();
    private static final NamespaceProperties NS_PROPS = NamespaceProperties.newBuilder().build();
    private static final String STREAM_NAME = "test-stream";
    private static final StreamConfiguration STREAM_CONF = StreamConfiguration.newBuilder().build();
    private static final StreamProperties STREAM_PROPS = StreamProperties.newBuilder().build();
    private AtomicInteger callCounter;
    private RootRangeClient client;
    private OrderedScheduler scheduler;
    private RootRangeClientImplWithRetries clientWithRetries;

    @Before
    public void setup() {
        this.callCounter = new AtomicInteger(3);
        this.client = (RootRangeClient)Mockito.mock(RootRangeClient.class);
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-scheduler").numThreads(1).build();
        this.clientWithRetries = new RootRangeClientImplWithRetries(this.client, (Backoff.Policy)Backoff.Constant.of((long)10L, (long)3L), this.scheduler);
    }

    @Test
    public void testCreateNamespace() throws Exception {
        Mockito.when((Object)this.client.createNamespace(ArgumentMatchers.anyString(), (NamespaceConfiguration)ArgumentMatchers.any(NamespaceConfiguration.class))).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)NS_PROPS);
        });
        Assert.assertSame((Object)NS_PROPS, (Object)FutureUtils.result((CompletableFuture)this.clientWithRetries.createNamespace(NS_NAME, NS_CONF)));
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        Mockito.when((Object)this.client.deleteNamespace(ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)true);
        });
        Assert.assertTrue((boolean)((Boolean)FutureUtils.result((CompletableFuture)this.clientWithRetries.deleteNamespace(NS_NAME))));
    }

    @Test
    public void testGetNamespace() throws Exception {
        Mockito.when((Object)this.client.getNamespace(ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)NS_PROPS);
        });
        Assert.assertSame((Object)NS_PROPS, (Object)FutureUtils.result((CompletableFuture)this.clientWithRetries.getNamespace(NS_NAME)));
    }

    @Test
    public void testCreateStream() throws Exception {
        Mockito.when((Object)this.client.createStream(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (StreamConfiguration)ArgumentMatchers.any(StreamConfiguration.class))).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)STREAM_PROPS);
        });
        Assert.assertSame((Object)STREAM_PROPS, (Object)FutureUtils.result((CompletableFuture)this.clientWithRetries.createStream(NS_NAME, STREAM_NAME, STREAM_CONF)));
    }

    @Test
    public void testDeleteStream() throws Exception {
        Mockito.when((Object)this.client.deleteStream(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)true);
        });
        Assert.assertTrue((boolean)((Boolean)FutureUtils.result((CompletableFuture)this.clientWithRetries.deleteStream(NS_NAME, STREAM_NAME))));
    }

    @Test
    public void testGetStream() throws Exception {
        Mockito.when((Object)this.client.getStream(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)STREAM_PROPS);
        });
        Assert.assertSame((Object)STREAM_PROPS, (Object)FutureUtils.result((CompletableFuture)this.clientWithRetries.getStream(NS_NAME, STREAM_NAME)));
    }

    @Test
    public void testGetStreamById() throws Exception {
        Mockito.when((Object)this.client.getStream(ArgumentMatchers.anyLong())).thenAnswer(invocationOnMock -> {
            if (this.callCounter.decrementAndGet() > 0) {
                return FutureUtils.exception((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
            }
            return FutureUtils.value((Object)STREAM_PROPS);
        });
        Assert.assertSame((Object)STREAM_PROPS, (Object)FutureUtils.result((CompletableFuture)this.clientWithRetries.getStream(1234L)));
    }
}

