/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.exceptions.InvalidNamespaceNameException;
import org.apache.bookkeeper.clients.exceptions.NamespaceExistsException;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StreamExistsException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.clients.grpc.GrpcClientTestBase;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannelManager;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelManager;
import org.apache.bookkeeper.clients.impl.internal.ProtocolInternalUtils;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImpl;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.proto.storage.RootRangeServiceGrpc;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public abstract class RootRangeClientImplTestBase
extends GrpcClientTestBase {
    @Rule
    public final TestName testName = new TestName();
    private OrderedScheduler scheduler;
    private RootRangeClientImpl rootRangeClient;
    private final LocationClient locationClient = (LocationClient)Mockito.mock(LocationClient.class);
    private StorageServerChannel mockChannel = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    private StorageServerChannel mockChannel2 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    private StorageServerChannel mockChannel3 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    private final Endpoint endpoint = Endpoint.newBuilder().setHostname("127.0.0.1").setPort(8181).build();
    private final Endpoint endpoint2 = Endpoint.newBuilder().setHostname("127.0.0.2").setPort(8282).build();
    private final Endpoint endpoint3 = Endpoint.newBuilder().setHostname("127.0.0.3").setPort(8383).build();
    private final StorageServerChannelManager channelManager = new StorageServerChannelManager(ep -> {
        if (this.endpoint2 == ep) {
            return this.mockChannel2;
        }
        if (this.endpoint3 == ep) {
            return this.mockChannel3;
        }
        return this.mockChannel;
    });

    @Override
    protected void doSetup() throws Exception {
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test-range-server-manager").build();
        this.rootRangeClient = new RootRangeClientImpl(this.scheduler, new StorageContainerChannelManager(this.channelManager, this.locationClient, this.scheduler));
    }

    @Override
    protected void doTeardown() throws Exception {
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    protected abstract RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForSuccess();

    protected abstract void verifySuccess(RootRangeClient var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestSuccess() throws Exception {
        CompletableFuture serviceFuture = FutureUtils.createFuture();
        this.rootRangeClient.getStorageContainerClient().setStorageServerChannelFuture(serviceFuture);
        RootRangeServiceGrpc.RootRangeServiceImplBase rootRangeService = this.createRootRangeServiceForSuccess();
        this.serviceRegistry.addService(rootRangeService.bindService());
        StorageServerChannel rsChannel = new StorageServerChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build(), Optional.empty());
        try {
            serviceFuture.complete(rsChannel);
            this.verifySuccess((RootRangeClient)this.rootRangeClient);
        }
        finally {
            if (Collections.singletonList(rsChannel).get(0) != null) {
                rsChannel.close();
            }
        }
    }

    protected abstract RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRequestFailure();

    protected abstract void verifyRequestFailure(RootRangeClient var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestFailure() throws Exception {
        CompletableFuture serviceFuture = FutureUtils.createFuture();
        this.rootRangeClient.getStorageContainerClient().setStorageServerChannelFuture(serviceFuture);
        RootRangeServiceGrpc.RootRangeServiceImplBase rootRangeService = this.createRootRangeServiceForRequestFailure();
        this.serviceRegistry.addService(rootRangeService.bindService());
        StorageServerChannel rsChannel = new StorageServerChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build(), Optional.empty());
        try {
            serviceFuture.complete(rsChannel);
            this.verifyRequestFailure((RootRangeClient)this.rootRangeClient);
        }
        finally {
            if (Collections.singletonList(rsChannel).get(0) != null) {
                rsChannel.close();
            }
        }
    }

    protected abstract RootRangeServiceGrpc.RootRangeServiceImplBase createRootRangeServiceForRpcFailure();

    protected abstract void verifyRpcFailure(RootRangeClient var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcFailure() throws Exception {
        CompletableFuture serviceFuture = FutureUtils.createFuture();
        this.rootRangeClient.getStorageContainerClient().setStorageServerChannelFuture(serviceFuture);
        RootRangeServiceGrpc.RootRangeServiceImplBase rootRangeService = this.createRootRangeServiceForRpcFailure();
        this.serviceRegistry.addService(rootRangeService.bindService());
        StorageServerChannel rsChannel = new StorageServerChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build(), Optional.empty());
        try {
            serviceFuture.complete(rsChannel);
            this.verifyRpcFailure((RootRangeClient)this.rootRangeClient);
        }
        finally {
            if (Collections.singletonList(rsChannel).get(0) != null) {
                rsChannel.close();
            }
        }
    }

    protected abstract void verifyChannelFailure(IOException var1, RootRangeClient var2) throws Exception;

    @Test
    public void testChannelFailure() throws Exception {
        CompletableFuture serviceFuture = FutureUtils.createFuture();
        this.rootRangeClient.getStorageContainerClient().setStorageServerChannelFuture(serviceFuture);
        IOException ioe = new IOException(this.testName.getMethodName());
        serviceFuture.completeExceptionally(ioe);
        this.verifyChannelFailure(ioe, (RootRangeClient)this.rootRangeClient);
    }

    @Test
    public void testCreateRootRangeException() {
        String name = "test-create-root-range-exception";
        Throwable cause1 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.STREAM_EXISTS);
        Assert.assertTrue((boolean)(cause1 instanceof StreamExistsException));
        StreamExistsException see = (StreamExistsException)cause1;
        Throwable cause2 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.STREAM_NOT_FOUND);
        Assert.assertTrue((boolean)(cause2 instanceof StreamNotFoundException));
        StreamNotFoundException snfe = (StreamNotFoundException)cause2;
        Throwable cause3 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.FAILURE);
        Assert.assertTrue((boolean)(cause3 instanceof ClientException));
        ClientException se = (ClientException)cause3;
        Assert.assertEquals((Object)("fail to access its root range : code = " + StatusCode.FAILURE), (Object)se.getMessage());
        Throwable cause4 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.BAD_VERSION);
        Assert.assertTrue((boolean)(cause4 instanceof ClientException));
        Throwable cause5 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.NAMESPACE_EXISTS);
        Assert.assertTrue((boolean)(cause5 instanceof NamespaceExistsException));
        Throwable cause6 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.NAMESPACE_NOT_FOUND);
        Assert.assertTrue((boolean)(cause6 instanceof NamespaceNotFoundException));
        Throwable cause7 = ProtocolInternalUtils.createRootRangeException((String)name, (StatusCode)StatusCode.INVALID_NAMESPACE_NAME);
        Assert.assertTrue((boolean)(cause7 instanceof InvalidNamespaceNameException));
    }
}

