/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.container;

import org.apache.bookkeeper.clients.impl.container.StorageContainerInfo;
import org.apache.bookkeeper.clients.impl.container.StorageContainerManager;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.junit.Assert;
import org.junit.Test;

public class TestStorageContainerManager {
    private final StorageContainerManager manager = new StorageContainerManager();
    private final Endpoint endpoint1 = Endpoint.newBuilder().setHostname("128.0.0.1").setPort(3181).build();
    private final Endpoint endpoint2 = Endpoint.newBuilder().setHostname("128.0.0.1").setPort(3181).build();

    @Test
    public void testGetNullStorageContainer() {
        Assert.assertNull((Object)this.manager.getStorageContainer(1234L));
    }

    @Test
    public void testAddStorageContainer() {
        long groupId = 1234L;
        long revision = 5678L;
        StorageContainerInfo sc1 = StorageContainerInfo.of((long)groupId, (long)revision, (Endpoint)this.endpoint1);
        Assert.assertNull((Object)this.manager.getStorageContainer(groupId));
        Assert.assertTrue((boolean)this.manager.replaceStorageContainer(groupId, sc1));
        Assert.assertTrue((sc1 == this.manager.getStorageContainer(groupId) ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceStorageContainerWithNewerRevision() {
        long groupId = 1234L;
        long revision1 = 5678L;
        long revision2 = 5679L;
        StorageContainerInfo sc1 = StorageContainerInfo.of((long)groupId, (long)revision1, (Endpoint)this.endpoint1);
        StorageContainerInfo sc2 = StorageContainerInfo.of((long)groupId, (long)revision2, (Endpoint)this.endpoint2);
        Assert.assertNull((Object)this.manager.getStorageContainer(groupId));
        Assert.assertTrue((boolean)this.manager.replaceStorageContainer(groupId, sc1));
        Assert.assertTrue((sc1 == this.manager.getStorageContainer(groupId) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.manager.replaceStorageContainer(groupId, sc2));
        Assert.assertTrue((sc2 == this.manager.getStorageContainer(groupId) ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceStorageContainerWithOlderRevision() {
        long groupId = 1234L;
        long revision1 = 5678L;
        long revision2 = 5679L;
        StorageContainerInfo sc1 = StorageContainerInfo.of((long)groupId, (long)revision1, (Endpoint)this.endpoint1);
        StorageContainerInfo sc2 = StorageContainerInfo.of((long)groupId, (long)revision2, (Endpoint)this.endpoint2);
        Assert.assertNull((Object)this.manager.getStorageContainer(groupId));
        Assert.assertTrue((boolean)this.manager.replaceStorageContainer(groupId, sc2));
        Assert.assertTrue((sc2 == this.manager.getStorageContainer(groupId) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.manager.replaceStorageContainer(groupId, sc1));
        Assert.assertTrue((sc2 == this.manager.getStorageContainer(groupId) ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveStorageContainer() {
        long groupId = 1234L;
        long revision = 5678L;
        StorageContainerInfo sc1 = StorageContainerInfo.of((long)groupId, (long)revision, (Endpoint)this.endpoint1);
        Assert.assertNull((Object)this.manager.getStorageContainer(groupId));
        Assert.assertTrue((boolean)this.manager.replaceStorageContainer(groupId, sc1));
        Assert.assertTrue((sc1 == this.manager.getStorageContainer(groupId) ? 1 : 0) != 0);
        this.manager.removeStorageContainer(groupId);
        Assert.assertNull((Object)this.manager.getStorageContainer(groupId));
    }
}

