/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.container;

import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelFactory;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStorageContainerChannelManager {
    @Test
    public void testGetOrCreate() {
        StorageContainerChannel channel1 = (StorageContainerChannel)Mockito.mock(StorageContainerChannel.class);
        StorageContainerChannel channel2 = (StorageContainerChannel)Mockito.mock(StorageContainerChannel.class);
        StorageContainerChannel channel3 = (StorageContainerChannel)Mockito.mock(StorageContainerChannel.class);
        StorageContainerChannelFactory factory = (StorageContainerChannelFactory)Mockito.mock(StorageContainerChannelFactory.class);
        StorageContainerChannelManager manager = new StorageContainerChannelManager(factory);
        Mockito.when((Object)factory.createStorageContainerChannel(ArgumentMatchers.anyLong())).thenReturn((Object)channel1).thenReturn((Object)channel2).thenReturn((Object)channel3);
        Assert.assertNull((Object)manager.remove(1L));
        Assert.assertEquals((Object)channel1, (Object)manager.getOrCreate(1L));
        ((StorageContainerChannelFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).createStorageContainerChannel(ArgumentMatchers.eq((long)1L));
        Assert.assertEquals((Object)channel1, (Object)manager.getOrCreate(1L));
        ((StorageContainerChannelFactory)Mockito.verify((Object)factory, (VerificationMode)Mockito.times((int)1))).createStorageContainerChannel(ArgumentMatchers.eq((long)1L));
        Assert.assertEquals((Object)channel1, (Object)manager.remove(1L));
    }

    @Test
    public void testClear() throws Exception {
        StorageContainerChannelManager manager = new StorageContainerChannelManager(scId -> (StorageContainerChannel)Mockito.mock(StorageContainerChannel.class));
        int numChannels = 10;
        for (int i = 0; i < numChannels; ++i) {
            Assert.assertNotNull((Object)manager.getOrCreate((long)i));
        }
        Assert.assertEquals((long)numChannels, (long)manager.getNumChannels());
        manager.close();
        Assert.assertEquals((long)0L, (long)manager.getNumChannels());
    }
}

