/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.container;

import com.google.common.collect.Lists;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.bookkeeper.clients.grpc.GrpcClientTestBase;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannelManager;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerInfo;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.exceptions.ObjectClosedException;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerEndpoint;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStorageContainerChannel
extends GrpcClientTestBase {
    private OrderedScheduler scheduler;
    private final LocationClient locationClient = (LocationClient)Mockito.mock(LocationClient.class);
    private StorageServerChannel mockChannel = this.newMockServerChannel();
    private StorageServerChannel mockChannel2 = this.newMockServerChannel();
    private StorageServerChannel mockChannel3 = this.newMockServerChannel();
    private final Endpoint endpoint = Endpoint.newBuilder().setHostname("127.0.0.1").setPort(8181).build();
    private final Endpoint endpoint2 = Endpoint.newBuilder().setHostname("127.0.0.2").setPort(8282).build();
    private final Endpoint endpoint3 = Endpoint.newBuilder().setHostname("127.0.0.3").setPort(8383).build();
    private final StorageServerChannelManager channelManager = new StorageServerChannelManager(ep -> {
        if (this.endpoint2 == ep) {
            return this.mockChannel2;
        }
        if (this.endpoint3 == ep) {
            return this.mockChannel3;
        }
        return this.mockChannel;
    });
    private StorageContainerChannel scClient;

    @Override
    protected void doSetup() throws Exception {
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).name("test-range-server-manager").build();
        this.scClient = new StorageContainerChannel(0L, this.channelManager, this.locationClient, (ScheduledExecutorService)this.scheduler.chooseThread(0L));
    }

    @Override
    protected void doTeardown() throws Exception {
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    private StorageServerChannel newMockServerChannel() {
        StorageServerChannel channel = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        Mockito.when((Object)channel.intercept(ArgumentMatchers.anyLong())).thenReturn((Object)channel);
        return channel;
    }

    private void ensureCallbackExecuted() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.scheduler.submit(() -> latch.countDown());
        latch.await();
    }

    @Test
    public void testGetRootRangeServiceSuccess() throws Exception {
        CompletableFuture locateResponses = FutureUtils.createFuture();
        Mockito.when((Object)this.locationClient.locateStorageContainers(ArgumentMatchers.anyList())).thenReturn((Object)locateResponses);
        Assert.assertNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        CompletableFuture rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        Assert.assertNotNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        CompletableFuture rsChannelFuture1 = this.scClient.getStorageContainerChannelFuture();
        Assert.assertTrue((rsChannelFuture == rsChannelFuture1 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        OneStorageContainerEndpointResponse oneResp = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(1000L).setRwEndpoint(this.endpoint).addRoEndpoint(this.endpoint).build()).build();
        locateResponses.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp}));
        StorageServerChannel rsChannel = (StorageServerChannel)rsChannelFuture.get();
        Assert.assertTrue((rsChannel == this.mockChannel ? 1 : 0) != 0);
        StorageContainerInfo scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1000L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint, this.endpoint}), (Object)scInfo.getReadEndpoints());
        Assert.assertEquals((Object)this.mockChannel, (Object)this.channelManager.getChannel(this.endpoint));
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
    }

    @Test
    public void testGetRootRangeServiceFailureWhenClosingChannelManager() throws Exception {
        CompletableFuture locateResponses = FutureUtils.createFuture();
        Mockito.when((Object)this.locationClient.locateStorageContainers(ArgumentMatchers.anyList())).thenReturn((Object)locateResponses);
        Assert.assertNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        CompletableFuture rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        Assert.assertNotNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        CompletableFuture rsChannelFuture1 = this.scClient.getStorageContainerChannelFuture();
        Assert.assertTrue((rsChannelFuture == rsChannelFuture1 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        this.channelManager.close();
        OneStorageContainerEndpointResponse oneResp = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(1000L).setRwEndpoint(this.endpoint).addRoEndpoint(this.endpoint).build()).build();
        locateResponses.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp}));
        try {
            rsChannelFuture.get();
            Assert.fail((String)"Should fail get root range service if channel manager is shutting down.");
        }
        catch (ExecutionException ee) {
            Assert.assertNotNull((Object)ee.getCause());
            Assert.assertTrue((boolean)(ee.getCause() instanceof ObjectClosedException));
        }
        StorageContainerInfo scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1000L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint, this.endpoint}), (Object)scInfo.getReadEndpoints());
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint));
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
    }

    @Test
    public void testGetRootRangeServiceFailureOnStaleGroupInfo() throws Exception {
        CompletableFuture locateResponses1 = FutureUtils.createFuture();
        CompletableFuture locateResponses2 = FutureUtils.createFuture();
        CompletableFuture locateResponses3 = FutureUtils.createFuture();
        Mockito.when((Object)this.locationClient.locateStorageContainers(ArgumentMatchers.anyList())).thenReturn((Object)locateResponses1).thenReturn((Object)locateResponses3);
        Assert.assertNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        CompletableFuture rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        Assert.assertNotNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        CompletableFuture rsChannelFuture1 = this.scClient.getStorageContainerChannelFuture();
        Assert.assertTrue((rsChannelFuture == rsChannelFuture1 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        OneStorageContainerEndpointResponse oneResp1 = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(1000L).setRwEndpoint(this.endpoint).addRoEndpoint(this.endpoint).build()).build();
        locateResponses1.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp1}));
        StorageServerChannel rsChannel = (StorageServerChannel)rsChannelFuture.get();
        Assert.assertTrue((rsChannel == this.mockChannel ? 1 : 0) != 0);
        StorageContainerInfo scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1000L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint, this.endpoint}), (Object)scInfo.getReadEndpoints());
        Assert.assertEquals((Object)this.mockChannel, (Object)this.channelManager.getChannel(this.endpoint));
        this.scClient.resetStorageServerChannelFuture();
        rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        OneStorageContainerEndpointResponse oneResp2 = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(999L).setRwEndpoint(this.endpoint2).addRoEndpoint(this.endpoint2).build()).build();
        locateResponses2.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp2}));
        this.ensureCallbackExecuted();
        scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1000L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint, this.endpoint}), (Object)scInfo.getReadEndpoints());
        Assert.assertFalse((boolean)rsChannelFuture.isDone());
        this.scClient.resetStorageServerChannelFuture();
        rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        OneStorageContainerEndpointResponse oneResp3 = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(1001L).setRwEndpoint(this.endpoint3).addRoEndpoint(this.endpoint3).build()).build();
        locateResponses3.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp3}));
        this.ensureCallbackExecuted();
        StorageServerChannel rsChannel3 = (StorageServerChannel)rsChannelFuture.get();
        Assert.assertTrue((rsChannel3 == this.mockChannel3 ? 1 : 0) != 0);
        scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1001L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint3, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint3, this.endpoint3}), (Object)scInfo.getReadEndpoints());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)3))).locateStorageContainers(ArgumentMatchers.anyList());
    }

    @Test
    public void testGetRootRangeServiceUnexpectedException() throws Exception {
        CompletableFuture locateResponses1 = FutureUtils.createFuture();
        CompletableFuture locateResponses2 = FutureUtils.createFuture();
        Mockito.when((Object)this.locationClient.locateStorageContainers(ArgumentMatchers.anyList())).thenReturn((Object)locateResponses1).thenReturn((Object)locateResponses2);
        Assert.assertNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        CompletableFuture rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        Assert.assertNotNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        CompletableFuture rsChannelFuture1 = this.scClient.getStorageContainerChannelFuture();
        Assert.assertTrue((rsChannelFuture == rsChannelFuture1 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        OneStorageContainerEndpointResponse oneResp = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(1000L).setRwEndpoint(this.endpoint).addRoEndpoint(this.endpoint).build()).build();
        locateResponses1.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp, oneResp}));
        this.ensureCallbackExecuted();
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint));
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        locateResponses2.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp}));
        StorageServerChannel rsChannel = (StorageServerChannel)rsChannelFuture.get();
        Assert.assertTrue((rsChannel == this.mockChannel ? 1 : 0) != 0);
        StorageContainerInfo scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1000L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint, this.endpoint}), (Object)scInfo.getReadEndpoints());
        Assert.assertEquals((Object)this.mockChannel, (Object)this.channelManager.getChannel(this.endpoint));
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)2))).locateStorageContainers(ArgumentMatchers.anyList());
    }

    @Test
    public void testGetRootRangeServiceExceptionally() throws Exception {
        CompletableFuture locateResponses1 = FutureUtils.createFuture();
        CompletableFuture locateResponses2 = FutureUtils.createFuture();
        Mockito.when((Object)this.locationClient.locateStorageContainers(ArgumentMatchers.anyList())).thenReturn((Object)locateResponses1).thenReturn((Object)locateResponses2);
        Assert.assertNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        CompletableFuture rsChannelFuture = this.scClient.getStorageContainerChannelFuture();
        Assert.assertNotNull((Object)this.scClient.getStorageServerChannelFuture());
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        CompletableFuture rsChannelFuture1 = this.scClient.getStorageContainerChannelFuture();
        Assert.assertTrue((rsChannelFuture == rsChannelFuture1 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)1))).locateStorageContainers(ArgumentMatchers.anyList());
        OneStorageContainerEndpointResponse oneResp = OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(0L).setRevision(1000L).setRwEndpoint(this.endpoint).addRoEndpoint(this.endpoint).build()).build();
        locateResponses1.completeExceptionally((Throwable)new ClientException("test-exception"));
        this.ensureCallbackExecuted();
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint));
        Assert.assertNull((Object)this.scClient.getStorageContainerInfo());
        locateResponses2.complete(Lists.newArrayList((Object[])new OneStorageContainerEndpointResponse[]{oneResp}));
        StorageServerChannel rsChannel = (StorageServerChannel)rsChannelFuture.get();
        Assert.assertTrue((rsChannel == this.mockChannel ? 1 : 0) != 0);
        StorageContainerInfo scInfo = this.scClient.getStorageContainerInfo();
        Assert.assertEquals((long)0L, (long)scInfo.getGroupId());
        Assert.assertEquals((long)1000L, (long)scInfo.getRevision());
        Assert.assertEquals((Object)this.endpoint, (Object)scInfo.getWriteEndpoint());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Endpoint[]{this.endpoint, this.endpoint}), (Object)scInfo.getReadEndpoints());
        Assert.assertEquals((Object)this.mockChannel, (Object)this.channelManager.getChannel(this.endpoint));
        ((LocationClient)Mockito.verify((Object)this.locationClient, (VerificationMode)Mockito.times((int)2))).locateStorageContainers(ArgumentMatchers.anyList());
    }
}

