/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.channel;

import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannelManager;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStorageServerChannelManager {
    private final Endpoint endpoint1 = Endpoint.newBuilder().setHostname("127.0.0.1").setPort(80).build();
    private final StorageServerChannel channel1 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    private final Endpoint endpoint2 = Endpoint.newBuilder().setHostname("127.0.0.2").setPort(8080).build();
    private final StorageServerChannel channel2 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    private final Endpoint endpoint3 = Endpoint.newBuilder().setHostname("127.0.0.3").setPort(8181).build();
    private final StorageServerChannelManager channelManager = new StorageServerChannelManager(endpoint -> {
        if (endpoint == this.endpoint1) {
            return this.channel1;
        }
        if (endpoint == this.endpoint2) {
            return this.channel2;
        }
        return (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
    });

    @After
    public void tearDown() {
        this.channelManager.close();
    }

    @Test
    public void testGetNullChannel() {
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
    }

    @Test
    public void testGetOrCreateChannel() {
        StorageServerChannel channel = this.channelManager.getOrCreateChannel(this.endpoint1);
        Assert.assertTrue((channel == this.channel1 ? 1 : 0) != 0);
        channel = this.channelManager.getOrCreateChannel(this.endpoint2);
        Assert.assertTrue((channel == this.channel2 ? 1 : 0) != 0);
        channel = this.channelManager.getOrCreateChannel(this.endpoint3);
        Assert.assertTrue((channel != this.channel1 && channel != this.channel2 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)this.channelManager.getNumChannels());
        this.channelManager.close();
        Assert.assertEquals((long)0L, (long)this.channelManager.getNumChannels());
        ((StorageServerChannel)Mockito.verify((Object)this.channel1, (VerificationMode)Mockito.times((int)1))).close();
        ((StorageServerChannel)Mockito.verify((Object)this.channel2, (VerificationMode)Mockito.times((int)1))).close();
        ((StorageServerChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testGetOrCreateChannelAfterClosed() {
        this.channelManager.close();
        Assert.assertNull((Object)this.channelManager.getOrCreateChannel(this.endpoint1));
        Assert.assertFalse((boolean)this.channelManager.contains(this.endpoint1));
        Assert.assertEquals((long)0L, (long)this.channelManager.getNumChannels());
    }

    @Test
    public void testAddRangeServer() {
        StorageServerChannel ch1 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        StorageServerChannel ch2 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
        Assert.assertTrue((boolean)this.channelManager.addStorageServer(this.endpoint1, ch1));
        Assert.assertTrue((ch1 == this.channelManager.getChannel(this.endpoint1) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.channelManager.getNumChannels());
        Assert.assertFalse((boolean)this.channelManager.addStorageServer(this.endpoint1, ch2));
        Assert.assertTrue((ch1 == this.channelManager.getChannel(this.endpoint1) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.channelManager.getNumChannels());
        ((StorageServerChannel)Mockito.verify((Object)ch2, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testAddRangeServerAfterClosed() {
        this.channelManager.close();
        StorageServerChannel ch1 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
        Assert.assertFalse((boolean)this.channelManager.addStorageServer(this.endpoint1, ch1));
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
        Assert.assertEquals((long)0L, (long)this.channelManager.getNumChannels());
        ((StorageServerChannel)Mockito.verify((Object)ch1, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testRemoveChannel() {
        StorageServerChannel ch = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
        Assert.assertTrue((boolean)this.channelManager.addStorageServer(this.endpoint1, ch));
        Assert.assertTrue((ch == this.channelManager.getChannel(this.endpoint1) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.channelManager.getNumChannels());
        Assert.assertTrue((ch == this.channelManager.removeChannel(this.endpoint1, null) ? 1 : 0) != 0);
        ((StorageServerChannel)Mockito.verify((Object)ch, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertEquals((long)0L, (long)this.channelManager.getNumChannels());
    }

    @Test
    public void testRemoveChannelAfterClosed() {
        this.channelManager.close();
        Assert.assertNull((Object)this.channelManager.removeChannel(this.endpoint1, null));
    }

    @Test
    public void testConditionalRemoveChannelSuccess() {
        StorageServerChannel ch1 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
        Assert.assertTrue((boolean)this.channelManager.addStorageServer(this.endpoint1, ch1));
        Assert.assertTrue((ch1 == this.channelManager.getChannel(this.endpoint1) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.channelManager.getNumChannels());
        Assert.assertTrue((ch1 == this.channelManager.removeChannel(this.endpoint1, ch1) ? 1 : 0) != 0);
        ((StorageServerChannel)Mockito.verify((Object)ch1, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertEquals((long)0L, (long)this.channelManager.getNumChannels());
    }

    @Test
    public void testConditionalRemoveChannelFailure() {
        StorageServerChannel ch1 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        StorageServerChannel ch2 = (StorageServerChannel)Mockito.mock(StorageServerChannel.class);
        Assert.assertNull((Object)this.channelManager.getChannel(this.endpoint1));
        Assert.assertTrue((boolean)this.channelManager.addStorageServer(this.endpoint1, ch1));
        Assert.assertTrue((ch1 == this.channelManager.getChannel(this.endpoint1) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.channelManager.getNumChannels());
        Assert.assertNull((Object)this.channelManager.removeChannel(this.endpoint1, ch2));
        ((StorageServerChannel)Mockito.verify((Object)ch1, (VerificationMode)Mockito.times((int)0))).close();
        ((StorageServerChannel)Mockito.verify((Object)ch2, (VerificationMode)Mockito.times((int)0))).close();
        Assert.assertEquals((long)1L, (long)this.channelManager.getNumChannels());
    }
}

