/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.channel;

import io.grpc.HandlerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.util.MutableHandlerRegistry;
import java.util.Optional;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStorageServerChannel {
    private final String serverName = "fake server for " + this.getClass();
    private final MutableHandlerRegistry serviceRegistry = new MutableHandlerRegistry();
    private Server fakeServer;

    @Before
    public void setUp() throws Exception {
        this.fakeServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)this.serverName).fallbackHandlerRegistry((HandlerRegistry)this.serviceRegistry)).directExecutor()).build().start();
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.fakeServer) {
            this.fakeServer.shutdown();
        }
    }

    @Test
    public void testBasic() {
        ManagedChannel managedChannel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build();
        Optional token = Optional.empty();
        StorageServerChannel channel = new StorageServerChannel(managedChannel, token);
        Assert.assertNotNull((Object)channel.getRootRangeService());
        Assert.assertNotNull((Object)channel.getMetaRangeService());
        Assert.assertNotNull((Object)channel.getStorageContainerService());
        Assert.assertNotNull((Object)channel.getTableService());
        channel.close();
    }

    @Test
    public void testIntercept() {
        ManagedChannel channel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        StorageServerChannel ssChannel = new StorageServerChannel(channel, Optional.empty());
        StorageServerChannel interceptedChannel = ssChannel.intercept(1L);
        interceptedChannel.close();
        ((ManagedChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).shutdown();
    }
}

