/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.grpc;

import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.util.MutableHandlerRegistry;
import java.util.Optional;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.internal.StorageServerClientManagerImpl;
import org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerEndpoint;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerServiceGrpc;
import org.junit.After;
import org.junit.Before;

public abstract class GrpcClientTestBase {
    protected static final Endpoint ENDPOINT = Endpoint.newBuilder().setHostname("127.0.0.1").setPort(4181).build();
    protected String serverName;
    protected final MutableHandlerRegistry serviceRegistry = new MutableHandlerRegistry();
    protected Server fakeServer;
    protected OrderedScheduler scheduler;
    protected StorageClientSettings settings;
    protected final ClientResources resources = ClientResources.create();
    protected StorageServerClientManagerImpl serverManager;

    @Before
    public void setUp() throws Exception {
        this.serverName = "fake-server:4181";
        this.fakeServer = ((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)this.serverName).fallbackHandlerRegistry((HandlerRegistry)this.serviceRegistry)).directExecutor()).build().start();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("scheduler-" + this.getClass()).numThreads(Runtime.getRuntime().availableProcessors()).build();
        this.settings = StorageClientSettings.newBuilder().serviceUri("bk+inprocess://" + this.serverName).build();
        this.serverManager = new StorageServerClientManagerImpl(this.settings, this.resources.scheduler(), endpoint -> new StorageServerChannel(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.serverName).directExecutor()).build(), Optional.empty()));
        StorageContainerServiceGrpc.StorageContainerServiceImplBase scService = new StorageContainerServiceGrpc.StorageContainerServiceImplBase(){

            public void getStorageContainerEndpoint(GetStorageContainerEndpointRequest request, StreamObserver<GetStorageContainerEndpointResponse> responseObserver) {
                GetStorageContainerEndpointResponse.Builder respBuilder = GetStorageContainerEndpointResponse.newBuilder();
                respBuilder.setStatusCode(StatusCode.SUCCESS);
                for (OneStorageContainerEndpointRequest oneReq : request.getRequestsList()) {
                    OneStorageContainerEndpointResponse oneResp = OneStorageContainerEndpointResponse.newBuilder().setEndpoint(StorageContainerEndpoint.newBuilder().setStorageContainerId(oneReq.getStorageContainer()).setRevision(oneReq.getRevision() + 1L).setRwEndpoint(ENDPOINT)).build();
                    respBuilder.addResponses(oneResp);
                }
                responseObserver.onNext((Object)respBuilder.build());
                responseObserver.onCompleted();
            }
        };
        this.serviceRegistry.addService(scService.bindService());
        this.doSetup();
    }

    protected abstract void doSetup() throws Exception;

    @After
    public void tearDown() throws Exception {
        this.doTeardown();
        if (null != this.serverManager) {
            this.serverManager.close();
        }
        if (null != this.fakeServer) {
            this.fakeServer.shutdown();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    protected abstract void doTeardown() throws Exception;
}

