/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.config;

import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.junit.Assert;
import org.junit.Test;

public class TestStorageClientSettings {
    @Test
    public void testDefault() {
        StorageClientSettings settings = StorageClientSettings.newBuilder().serviceUri("bk://127.0.0.1:4181/").build();
        Assert.assertEquals((Object)"bk://127.0.0.1:4181/", (Object)settings.serviceUri());
        Assert.assertEquals((long)Runtime.getRuntime().availableProcessors(), (long)settings.numWorkerThreads());
        Assert.assertTrue((boolean)settings.usePlaintext());
        Assert.assertFalse((boolean)settings.clientName().isPresent());
    }

    @Test
    public void testEmptyBuilder() {
        try {
            StorageClientSettings.newBuilder().build();
            Assert.fail((String)"Should fail with missing endpoints");
        }
        catch (IllegalStateException iae) {
            Assert.assertEquals((Object)"Not set: [serviceUri]", (Object)iae.getMessage());
        }
    }
}

