/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.ostrich;

import com.twitter.ostrich.stats.StatsProvider;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.twitter.ostrich.CounterImpl;
import org.apache.bookkeeper.stats.twitter.ostrich.OpStatsLoggerImpl;
import scala.Function0;
import scala.runtime.AbstractFunction0;

class OstrichStatsLoggerImpl
implements StatsLogger {
    protected final String scope;
    protected final StatsProvider ostrichProvider;

    OstrichStatsLoggerImpl(String scope, StatsProvider ostrichProvider) {
        this.scope = scope;
        this.ostrichProvider = ostrichProvider;
    }

    public OpStatsLogger getOpStatsLogger(String statName) {
        return new OpStatsLoggerImpl(this.getStatName(statName), this.ostrichProvider);
    }

    public Counter getCounter(String statName) {
        return new CounterImpl(this.ostrichProvider.getCounter(this.getStatName(statName)));
    }

    public <T extends Number> void registerGauge(String statName, final Gauge<T> gauge) {
        AbstractFunction0<Object> gaugeFunc = new AbstractFunction0<Object>(){

            public Object apply() {
                return gauge.getSample().doubleValue();
            }
        };
        this.ostrichProvider.addGauge(this.getStatName(statName), (Function0)gaugeFunc);
    }

    public <T extends Number> void unregisterGauge(String statName, Gauge<T> gauge) {
        this.ostrichProvider.clearGauge(this.getStatName(statName));
    }

    private String getStatName(String statName) {
        return String.format("%s/%s", this.scope, statName);
    }

    public StatsLogger scope(String scope) {
        return new OstrichStatsLoggerImpl(this.getStatName(scope), this.ostrichProvider);
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }
}

