/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.ostrich;

import com.twitter.ostrich.stats.Counter;
import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.Histogram;
import com.twitter.ostrich.stats.Metric;
import com.twitter.ostrich.stats.StatsProvider;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;

class OpStatsLoggerImpl
implements OpStatsLogger {
    static final double[] PERCENTILES = new double[]{0.1, 0.5, 0.9, 0.99, 0.999, 0.9999};
    private final String scope;
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Metric successMetric;
    private final Metric failureMetric;

    OpStatsLoggerImpl(String scope, StatsProvider statsProvider) {
        this.scope = scope;
        this.successCounter = statsProvider.getCounter(this.statName("requests/success"));
        this.failureCounter = statsProvider.getCounter(this.statName("requests/failure"));
        this.successMetric = statsProvider.getMetric(this.statName("latency/success"));
        this.failureMetric = statsProvider.getMetric(this.statName("latency/failure"));
    }

    private String statName(String statName) {
        return String.format("%s/%s", this.scope, statName);
    }

    public void registerFailedEvent(long eventLatencyMillis) {
        this.failureMetric.add((int)eventLatencyMillis);
        this.failureCounter.incr();
    }

    public void registerSuccessfulEvent(long eventLatencyMillis) {
        this.successMetric.add((int)eventLatencyMillis);
        this.successCounter.incr();
    }

    public OpStatsData toOpStatsData() {
        long numSuccess = this.successCounter.apply();
        long numFailures = this.failureCounter.apply();
        Distribution distribution = this.successMetric.apply();
        Histogram histogram = distribution.histogram();
        double avgLatency = distribution.average();
        long[] percentiles = new long[PERCENTILES.length];
        int i = 0;
        for (double percentile : PERCENTILES) {
            percentiles[i] = histogram.getPercentile(percentile);
            ++i;
        }
        return new OpStatsData(numSuccess, numFailures, avgLatency, percentiles);
    }

    public void clear() {
        this.successCounter.reset();
        this.failureCounter.reset();
        this.successMetric.clear();
        this.failureMetric.clear();
    }
}

