/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.utils;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.Stats;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class StatsDocGenerator {
    private static final Logger log = LoggerFactory.getLogger(StatsDocGenerator.class);
    private final String packagePrefix;
    private final Reflections reflections;
    private final StatsProvider statsProvider;
    private final NavigableMap<String, NavigableMap<String, StatsDocEntry>> docEntries = new TreeMap<String, NavigableMap<String, StatsDocEntry>>();

    private static Reflections newReflections(String packagePrefix) {
        ArrayList<URL> urls = new ArrayList<URL>();
        ClassLoader[] classLoaders = new ClassLoader[]{StatsDocGenerator.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        for (int i = 0; i < classLoaders.length; ++i) {
            if (!(classLoaders[i] instanceof URLClassLoader)) {
                throw new RuntimeException("ClassLoader '" + classLoaders[i] + " is not an instance of URLClassLoader");
            }
            urls.addAll(Arrays.asList(((URLClassLoader)classLoaders[i]).getURLs()));
        }
        FilterBuilder filters = new FilterBuilder().includePackage(new String[]{packagePrefix});
        ConfigurationBuilder confBuilder = new ConfigurationBuilder();
        confBuilder.filterInputsBy((Predicate)filters);
        confBuilder.setUrls(urls);
        return new Reflections((Configuration)confBuilder);
    }

    public StatsDocGenerator(String packagePrefix, StatsProvider provider) {
        this.packagePrefix = packagePrefix;
        this.reflections = StatsDocGenerator.newReflections(packagePrefix);
        this.statsProvider = provider;
    }

    public void generate(String filename) throws Exception {
        log.info("Processing classes under package {}", (Object)this.packagePrefix);
        Set annotatedClasses = this.reflections.getTypesAnnotatedWith(StatsDoc.class);
        log.info("Retrieve all `StatsDoc` annotated classes : {}", (Object)annotatedClasses);
        for (Class annotatedClass : annotatedClasses) {
            this.generateDocForAnnotatedClass(annotatedClass);
        }
        log.info("Successfully processed classes under package {}", (Object)this.packagePrefix);
        log.info("Writing stats doc to file {}", (Object)filename);
        this.writeDoc(filename);
        log.info("Successfully wrote stats doc to file {}", (Object)filename);
    }

    private void generateDocForAnnotatedClass(Class<?> annotatedClass) {
        Field[] fields;
        StatsDoc scopeStatsDoc = annotatedClass.getDeclaredAnnotation(StatsDoc.class);
        if (scopeStatsDoc == null) {
            return;
        }
        log.info("Processing StatsDoc annotated class {} : {}", annotatedClass, (Object)scopeStatsDoc);
        for (Field field : fields = annotatedClass.getDeclaredFields()) {
            StatsDoc fieldStatsDoc = field.getDeclaredAnnotation(StatsDoc.class);
            if (null == fieldStatsDoc) continue;
            this.generateDocForAnnotatedField(scopeStatsDoc, fieldStatsDoc, field);
        }
        log.info("Successfully processed StatsDoc annotated class {}.", annotatedClass);
    }

    private NavigableMap<String, StatsDocEntry> getCategoryMap(String category) {
        TreeMap categoryMap = (TreeMap)this.docEntries.get(category);
        if (null == categoryMap) {
            categoryMap = new TreeMap();
            this.docEntries.put(category, categoryMap);
        }
        return categoryMap;
    }

    private void generateDocForAnnotatedField(StatsDoc scopedStatsDoc, StatsDoc fieldStatsDoc, Field field) {
        StatsType statsType;
        NavigableMap<String, StatsDocEntry> categoryMap = this.getCategoryMap(scopedStatsDoc.category());
        String statsName = this.statsProvider.getStatsName(new String[]{scopedStatsDoc.scope(), scopedStatsDoc.name(), fieldStatsDoc.name()});
        if (Counter.class.isAssignableFrom(field.getType())) {
            statsType = StatsType.COUNTER;
        } else if (Gauge.class.isAssignableFrom(field.getType())) {
            statsType = StatsType.GAUGE;
        } else if (OpStatsLogger.class.isAssignableFrom(field.getType())) {
            statsType = StatsType.OPSTATS;
        } else {
            throw new IllegalArgumentException("Unknown stats field '" + field.getName() + "' is annotated with `StatsDoc`: " + field.getType());
        }
        String helpDesc = fieldStatsDoc.help();
        StatsDocEntry docEntry = new StatsDocEntry(statsName, statsType, helpDesc);
        categoryMap.put(statsName, docEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoc(String file) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.LITERAL);
        Yaml yaml = new Yaml(options);
        try (OutputStreamWriter writer = Strings.isNullOrEmpty((String)file) ? new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Map<String, Map> docs = this.docEntries.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((NavigableMap)e.getValue()).entrySet().stream().collect(Collectors.toMap(e1 -> (String)e1.getKey(), e1 -> ((StatsDocEntry)e1.getValue()).properties()))));
            yaml.dump(docs, (Writer)writer);
            ((Writer)writer).flush();
        }
    }

    public static void main(String[] args) throws Exception {
        MainArgs mainArgs = new MainArgs();
        JCommander commander = new JCommander();
        try {
            commander.setProgramName("stats-doc-gen");
            commander.addObject((Object)mainArgs);
            commander.parse(args);
            if (mainArgs.help) {
                commander.usage();
                Runtime.getRuntime().exit(0);
                return;
            }
        }
        catch (Exception e) {
            commander.usage();
            Runtime.getRuntime().exit(-1);
            return;
        }
        Stats.loadStatsProvider((String)StatsDocGenerator.getStatsProviderClass(mainArgs.statsProviderClass));
        StatsProvider provider = Stats.get();
        StatsDocGenerator docGen = new StatsDocGenerator(mainArgs.packagePrefix, provider);
        docGen.generate(mainArgs.yamlFile);
    }

    private static String getStatsProviderClass(String providerClass) {
        switch (providerClass.toLowerCase()) {
            case "prometheus": {
                return "org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider";
            }
            case "codahale": {
                return "org.apache.bookkeeper.stats.codahale.CodahaleMetricsProvider";
            }
        }
        return providerClass;
    }

    private static class MainArgs {
        @Parameter(names={"-p", "--package"}, description="Package prefix of the classes to generate stats doc")
        String packagePrefix = "org.apache.bookkeeper";
        @Parameter(names={"-sp", "--stats-provider"}, description="The stats provider used for generating stats doc")
        String statsProviderClass = "prometheus";
        @Parameter(names={"-o", "--output-yaml-file"}, description="The output yaml file to dump stats docs. If omitted, the output goes to stdout.")
        String yamlFile = null;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        boolean help = false;

        private MainArgs() {
        }
    }

    static class StatsDocEntry {
        private String name;
        private StatsType type;
        private String description;

        public Map<String, String> properties() {
            TreeMap<String, String> properties = new TreeMap<String, String>();
            properties.put("type", this.type.name());
            properties.put("description", this.description);
            return properties;
        }

        public StatsDocEntry(String name, StatsType type, String description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public StatsType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(StatsType type) {
            this.type = type;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatsDocEntry)) {
                return false;
            }
            StatsDocEntry other = (StatsDocEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            StatsType this$type = this.getType();
            StatsType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatsDocEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            StatsType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "StatsDocGenerator.StatsDocEntry(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", description=" + this.getDescription() + ")";
        }
    }

    static enum StatsType {
        COUNTER,
        GAUGE,
        OPSTATS;

    }
}

