/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.google.common.collect.Lists;
import io.etcd.jetcd.Client;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.exceptions.Code;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.metadata.etcd.EtcdLayoutManager;
import org.apache.bookkeeper.metadata.etcd.EtcdLedgerManagerFactory;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdMetadataDriverBase
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(EtcdMetadataDriverBase.class);
    static final String SCHEME = "etcd";
    protected AbstractConfiguration<?> conf;
    protected StatsLogger statsLogger;
    protected Client client;
    protected String keyPrefix;
    protected LayoutManager layoutManager;
    protected LedgerManagerFactory lmFactory;

    EtcdMetadataDriverBase() {
    }

    public String getScheme() {
        return SCHEME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(AbstractConfiguration<?> conf, StatsLogger statsLogger) throws MetadataException {
        String metadataServiceUriStr;
        this.conf = conf;
        this.statsLogger = statsLogger;
        try {
            metadataServiceUriStr = conf.getMetadataServiceUri();
        }
        catch (ConfigurationException ce) {
            log.error("Failed to retrieve metadata service uri from configuration", (Throwable)ce);
            throw new MetadataException(Code.INVALID_METADATA_SERVICE_URI, (Throwable)ce);
        }
        ServiceURI serviceURI = ServiceURI.create((String)metadataServiceUriStr);
        this.keyPrefix = serviceURI.getServicePath();
        List<String> etcdEndpoints = Lists.newArrayList((Object[])serviceURI.getServiceHosts()).stream().map(host -> String.format("http://%s", host)).collect(Collectors.toList());
        log.info("Initializing etcd metadata driver : etcd endpoints = {}, key scope = {}", etcdEndpoints, (Object)this.keyPrefix);
        EtcdMetadataDriverBase etcdMetadataDriverBase = this;
        synchronized (etcdMetadataDriverBase) {
            this.client = Client.builder().endpoints(etcdEndpoints.toArray(new String[etcdEndpoints.size()])).build();
        }
        this.layoutManager = new EtcdLayoutManager(this.client, this.keyPrefix);
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public synchronized LedgerManagerFactory getLedgerManagerFactory() throws MetadataException {
        if (null == this.lmFactory) {
            try {
                this.lmFactory = new EtcdLedgerManagerFactory();
                this.lmFactory.initialize(this.conf, this.layoutManager, 0);
            }
            catch (IOException ioe) {
                throw new MetadataException(Code.METADATA_SERVICE_ERROR, "Failed to initialize ledger manager factory", (Throwable)ioe);
            }
        }
        return this.lmFactory;
    }

    @Override
    public synchronized void close() {
        if (null != this.lmFactory) {
            try {
                this.lmFactory.close();
            }
            catch (IOException e) {
                log.error("Failed to close ledger manager factory", (Throwable)e);
            }
            this.lmFactory = null;
        }
        if (null != this.client) {
            this.client.close();
            this.client = null;
        }
    }
}

