/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.metadata.etcd.EtcdMetadataDriverBase;
import org.apache.bookkeeper.metadata.etcd.EtcdRegistrationClient;
import org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdMetadataClientDriver
extends EtcdMetadataDriverBase
implements MetadataClientDriver {
    private static final Logger log = LoggerFactory.getLogger(EtcdMetadataClientDriver.class);
    ClientConfiguration conf;
    ScheduledExecutorService scheduler;
    RegistrationClient regClient;

    public MetadataClientDriver initialize(ClientConfiguration conf, ScheduledExecutorService scheduler, StatsLogger statsLogger, Optional<Object> ctx) throws MetadataException {
        super.initialize((AbstractConfiguration<?>)conf, statsLogger);
        this.conf = conf;
        this.statsLogger = statsLogger;
        return this;
    }

    public synchronized RegistrationClient getRegistrationClient() {
        if (null == this.regClient) {
            this.regClient = new EtcdRegistrationClient(this.keyPrefix, this.client);
        }
        return this.regClient;
    }

    @Override
    public synchronized void close() {
        if (null != this.regClient) {
            this.regClient.close();
            this.regClient = null;
        }
        super.close();
    }

    public void setSessionStateListener(MetadataClientDriver.SessionStateListener sessionStateListener) {
        throw new UnsupportedOperationException();
    }

    static {
        MetadataDrivers.registerClientDriver((String)"etcd", EtcdMetadataClientDriver.class);
        log.info("Registered etcd metadata client driver.");
    }
}

