/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.metadata.etcd.EtcdBookieRegister;
import org.apache.bookkeeper.metadata.etcd.EtcdMetadataDriverBase;
import org.apache.bookkeeper.metadata.etcd.EtcdRegistrationManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdMetadataBookieDriver
extends EtcdMetadataDriverBase
implements MetadataBookieDriver {
    private static final Logger log = LoggerFactory.getLogger(EtcdMetadataBookieDriver.class);
    ServerConfiguration conf;
    EtcdBookieRegister bkRegister;
    RegistrationManager regMgr;

    public synchronized MetadataBookieDriver initialize(ServerConfiguration conf, StatsLogger statsLogger) throws MetadataException {
        super.initialize((AbstractConfiguration<?>)conf, statsLogger);
        this.conf = conf;
        this.statsLogger = statsLogger;
        return null;
    }

    public synchronized RegistrationManager createRegistrationManager() {
        if (null == this.bkRegister) {
            this.bkRegister = new EtcdBookieRegister(this.client.getLeaseClient(), TimeUnit.MILLISECONDS.toSeconds(this.conf.getZkTimeout())).start();
        }
        if (null == this.regMgr) {
            this.regMgr = new EtcdRegistrationManager(this.client, this.keyPrefix, this.bkRegister);
        }
        return this.regMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        EtcdBookieRegister bkRegisterToClose;
        RegistrationManager rmToClose;
        EtcdMetadataBookieDriver etcdMetadataBookieDriver = this;
        synchronized (etcdMetadataBookieDriver) {
            rmToClose = this.regMgr;
            this.regMgr = null;
            bkRegisterToClose = this.bkRegister;
            this.bkRegister = null;
        }
        if (null != rmToClose) {
            rmToClose.close();
        }
        if (null != bkRegisterToClose) {
            bkRegisterToClose.close();
        }
        super.close();
    }

    static {
        MetadataDrivers.registerBookieDriver((String)"etcd", EtcdMetadataBookieDriver.class);
        log.info("Registered etcd metadata bookie driver");
    }
}

