/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.Client;
import java.io.IOException;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.metadata.etcd.Etcd64bitIdGenerator;
import org.apache.bookkeeper.metadata.etcd.EtcdLayoutManager;
import org.apache.bookkeeper.metadata.etcd.EtcdLedgerManager;
import org.apache.bookkeeper.metadata.etcd.EtcdRegistrationManager;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.zookeeper.KeeperException;

class EtcdLedgerManagerFactory
implements LedgerManagerFactory {
    static final int VERSION = 0;
    private String scope;
    private Client client;

    EtcdLedgerManagerFactory() {
    }

    public int getCurrentVersion() {
        return 0;
    }

    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager layoutManager, int factoryVersion) throws IOException {
        Preconditions.checkArgument((boolean)(layoutManager instanceof EtcdLayoutManager));
        EtcdLayoutManager etcdLayoutManager = (EtcdLayoutManager)layoutManager;
        if (0 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        try {
            ServiceURI uri = ServiceURI.create((String)conf.getMetadataServiceUri());
            this.scope = uri.getServicePath();
        }
        catch (ConfigurationException e) {
            throw new IOException("Invalid metadata service uri", e);
        }
        this.client = etcdLayoutManager.getClient();
        return this;
    }

    public void close() {
    }

    public LedgerIdGenerator newLedgerIdGenerator() {
        return new Etcd64bitIdGenerator(this.client.getKVClient(), this.scope);
    }

    public LedgerManager newLedgerManager() {
        return new EtcdLedgerManager(this.client, this.scope);
    }

    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws ReplicationException.UnavailableException, InterruptedException, ReplicationException.CompatibilityException {
        throw new UnsupportedOperationException();
    }

    public LedgerAuditorManager newLedgerAuditorManager() throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void format(AbstractConfiguration<?> conf, LayoutManager lm) throws InterruptedException, KeeperException, IOException {
        try {
            EtcdRegistrationManager.format(this.client.getKVClient(), this.scope);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public boolean validateAndNukeExistingCluster(AbstractConfiguration<?> conf, LayoutManager lm) throws InterruptedException, KeeperException, IOException {
        try {
            return EtcdRegistrationManager.nukeExistingCluster(this.client.getKVClient(), this.scope);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

