/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import io.etcd.jetcd.support.CloseableClient;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.metadata.etcd.EtcdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdBookieRegister
implements AutoCloseable,
Runnable,
Supplier<Long> {
    private static final Logger log = LoggerFactory.getLogger(EtcdBookieRegister.class);
    private final Lease leaseClient;
    private final long ttlSeconds;
    private final ScheduledExecutorService executor;
    private RegistrationManager.RegistrationListener regListener;
    private volatile CompletableFuture<Long> leaseFuture = new CompletableFuture();
    private volatile CompletableFuture<Void> keepAliveFuture = new CompletableFuture();
    private volatile long leaseId = -43981L;
    private volatile CloseableClient kaListener = null;
    private volatile boolean running = true;
    private long nextWaitTimeMs = 200L;
    private Future<?> runFuture = null;

    EtcdBookieRegister(Lease leaseClient, long ttlSeconds) {
        this.leaseClient = leaseClient;
        this.ttlSeconds = ttlSeconds;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("bookie-etcd-keepalive-thread").build());
    }

    public EtcdBookieRegister addRegistrationListener(RegistrationManager.RegistrationListener regListener) {
        this.regListener = regListener;
        return this;
    }

    long getTtlSeconds() {
        return this.ttlSeconds;
    }

    public synchronized EtcdBookieRegister start() {
        if (null == this.runFuture) {
            this.runFuture = this.executor.submit(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLeaseIfNeeded() throws BookieException.MetadataStoreException {
        boolean newLeaseNeeded;
        EtcdBookieRegister etcdBookieRegister = this;
        synchronized (etcdBookieRegister) {
            newLeaseNeeded = !this.leaseFuture.isDone();
        }
        if (newLeaseNeeded) {
            final long leaseId = ((LeaseGrantResponse)EtcdUtils.msResult(this.leaseClient.grant(this.ttlSeconds))).getID();
            this.keepAliveFuture = new CompletableFuture();
            if (this.kaListener != null) {
                EtcdBookieRegister etcdBookieRegister2 = this;
                synchronized (etcdBookieRegister2) {
                    this.kaListener.close();
                    this.kaListener = null;
                }
            }
            this.kaListener = this.leaseClient.keepAlive(leaseId, (StreamObserver)new StreamObserver<LeaseKeepAliveResponse>(){

                public void onNext(LeaseKeepAliveResponse response) {
                    log.info("KeepAlive response : lease = {}, ttl = {}", (Object)response.getID(), (Object)response.getTTL());
                }

                public void onError(Throwable t) {
                    log.info("KeepAlive renewal failed, leaseId {}", (Object)leaseId, (Object)t.fillInStackTrace());
                    EtcdBookieRegister.this.keepAliveFuture.completeExceptionally(t);
                }

                public void onCompleted() {
                    log.info("lease completed! leaseId {}", (Object)leaseId);
                    EtcdBookieRegister.this.keepAliveFuture.cancel(true);
                }
            });
            this.leaseId = leaseId;
            this.leaseFuture.complete(leaseId);
            log.info("New lease '{}' is granted.", (Object)leaseId);
        }
    }

    private void waitForNewLeaseId() {
        while (this.running) {
            try {
                this.newLeaseIfNeeded();
                this.nextWaitTimeMs = 100L;
            }
            catch (BookieException.MetadataStoreException e) {
                log.error("Failed to grant a new lease for leaseId {}", (Object)this.leaseId, (Object)e);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.nextWaitTimeMs);
                    this.nextWaitTimeMs *= 2L;
                    this.nextWaitTimeMs = Math.min(this.nextWaitTimeMs, TimeUnit.SECONDS.toMillis(this.ttlSeconds));
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted at backing off granting a new lease for leaseId {}", (Object)this.leaseId);
                }
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            this.waitForNewLeaseId();
            try {
                log.info("Keeping Alive at lease = {}", (Object)this.get());
                this.keepAliveFuture.get();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted at keeping lease '{}' alive", (Object)this.leaseId);
                this.resetLease();
            }
            catch (ExecutionException ee) {
                log.warn("Failed to keep alive lease '{}'", (Object)this.leaseId, (Object)ee);
                this.resetLease();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLease() {
        EtcdBookieRegister etcdBookieRegister = this;
        synchronized (etcdBookieRegister) {
            this.leaseFuture = new CompletableFuture();
        }
        if (null != this.regListener) {
            this.regListener.onRegistrationExpired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        EtcdBookieRegister etcdBookieRegister = this;
        synchronized (etcdBookieRegister) {
            if (!this.running) {
                return;
            }
            this.running = false;
            if (null != this.runFuture && this.runFuture.cancel(true)) {
                log.info("Successfully interrupted bookie register.");
            }
            this.keepAliveFuture.cancel(true);
            if (this.kaListener != null) {
                this.kaListener.close();
                this.kaListener = null;
            }
        }
        CompletableFuture closeFuture = new CompletableFuture();
        this.executor.submit(() -> FutureUtils.complete((CompletableFuture)closeFuture, (Object)null));
        closeFuture.join();
    }

    @Override
    public Long get() {
        while (true) {
            try {
                return this.leaseFuture.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted at getting lease id", (Throwable)e);
                return -1L;
            }
            catch (ExecutionException e) {
                throw new IllegalArgumentException("Should never reach here");
            }
            catch (TimeoutException e) {
                continue;
            }
            break;
        }
    }

    long getLeaseId() {
        return this.leaseId;
    }
}

