/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerLayout;
import org.apache.bookkeeper.metadata.etcd.EtcdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdLayoutManager
implements LayoutManager {
    private static final Logger log = LoggerFactory.getLogger(EtcdLayoutManager.class);
    private final Client client;
    private final KV kvClient;
    private final String scope;
    private final ByteSequence layoutKey;

    EtcdLayoutManager(Client client, String scope) {
        this.client = client;
        this.kvClient = client.getKVClient();
        this.scope = scope;
        this.layoutKey = ByteSequence.from((String)EtcdUtils.getLayoutKey(scope), (Charset)StandardCharsets.UTF_8);
    }

    public LedgerLayout readLedgerLayout() throws IOException {
        GetResponse response = (GetResponse)EtcdUtils.ioResult(this.kvClient.get(this.layoutKey, GetOption.DEFAULT));
        if (response.getCount() <= 0L) {
            return null;
        }
        byte[] layoutData = ((KeyValue)response.getKvs().get(0)).getValue().getBytes();
        return LedgerLayout.parseLayout((byte[])layoutData);
    }

    public void storeLedgerLayout(LedgerLayout layout) throws IOException {
        ByteSequence layoutData = ByteSequence.from((byte[])layout.serialize());
        TxnResponse response = (TxnResponse)EtcdUtils.ioResult(this.kvClient.txn().If(new Cmp[]{new Cmp(this.layoutKey, Cmp.Op.GREATER, (CmpTarget)CmpTarget.createRevision((long)0L))}).Then(new Op[]{Op.get((ByteSequence)this.layoutKey, (GetOption)GetOption.DEFAULT)}).Else(new Op[]{Op.put((ByteSequence)this.layoutKey, (ByteSequence)layoutData, (PutOption)PutOption.DEFAULT)}).commit());
        if (!response.isSucceeded()) {
            return;
        }
        GetResponse resp = (GetResponse)response.getGetResponses().get(0);
        if (resp.getCount() <= 0L) {
            throw new IOException("Creating layout node '" + this.layoutKey.toString(StandardCharsets.UTF_8) + "' failed due to it already exists but no layout node is found");
        }
        throw new LayoutManager.LedgerLayoutExistsException("Ledger layout already exists under '" + this.layoutKey.toString(StandardCharsets.UTF_8) + "'");
    }

    public void deleteLedgerLayout() throws IOException {
        DeleteResponse response = (DeleteResponse)EtcdUtils.ioResult(this.kvClient.delete(this.layoutKey));
        if (response.getDeleted() > 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Successfully delete layout '{}'", (Object)this.layoutKey.toString(StandardCharsets.UTF_8));
            }
            return;
        }
        throw new IOException("No ledger layout is found under '" + this.layoutKey.toString(StandardCharsets.UTF_8) + "'");
    }

    Client getClient() {
        return this.client;
    }

    KV getKvClient() {
        return this.kvClient;
    }

    String getScope() {
        return this.scope;
    }

    ByteSequence getLayoutKey() {
        return this.layoutKey;
    }
}

