/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.google.common.base.Preconditions;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.metadata.etcd.EtcdConstants;
import org.apache.bookkeeper.metadata.etcd.EtcdUtils;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Etcd64bitIdGenerator
implements LedgerIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(Etcd64bitIdGenerator.class);
    static final long MAX_ID_PER_BUCKET = 0xFFFFFFFFFFFFFFL;
    static final long BUCKET_ID_MASK = -72057594037927936L;
    static final int BUCKET_ID_SHIFT = 56;
    static final int NUM_BUCKETS = 128;
    private static final AtomicIntegerFieldUpdater<Etcd64bitIdGenerator> nextBucketIdUpdater = AtomicIntegerFieldUpdater.newUpdater(Etcd64bitIdGenerator.class, "nextBucketId");
    private final String scope;
    private final KV kvClient;
    private volatile int nextBucketId;

    static int getBucketId(long lid) {
        return (int)((lid & 0xFF00000000000000L) >>> 56);
    }

    static long getIdInBucket(long lid) {
        return lid & 0xFFFFFFFFFFFFFFL;
    }

    Etcd64bitIdGenerator(KV kvClient, String scope) {
        this.kvClient = kvClient;
        this.scope = scope;
        this.nextBucketId = ThreadLocalRandom.current().nextInt(128);
    }

    int nextBucketId() {
        int bucketId;
        while ((bucketId = nextBucketIdUpdater.incrementAndGet(this)) >= 128) {
            if (!nextBucketIdUpdater.compareAndSet(this, bucketId, 0)) continue;
            bucketId = 0;
            break;
        }
        return bucketId;
    }

    public void generateLedgerId(BookkeeperInternalCallbacks.GenericCallback<Long> cb) {
        int bucketId = this.nextBucketId();
        Preconditions.checkArgument((bucketId >= 0 && bucketId < 128 ? 1 : 0) != 0, (Object)("Invalid bucket id : " + bucketId));
        ByteSequence bucketKey = ByteSequence.from((String)EtcdUtils.getBucketPath(this.scope, bucketId), (Charset)StandardCharsets.UTF_8);
        Txn txn = this.kvClient.txn().If(new Cmp[]{new Cmp(bucketKey, Cmp.Op.GREATER, (CmpTarget)CmpTarget.createRevision((long)0L))}).Then(new Op[]{Op.put((ByteSequence)bucketKey, (ByteSequence)EtcdConstants.EMPTY_BS, (PutOption)PutOption.DEFAULT), Op.get((ByteSequence)bucketKey, (GetOption)GetOption.DEFAULT)}).Else(new Op[]{Op.put((ByteSequence)bucketKey, (ByteSequence)EtcdConstants.EMPTY_BS, (PutOption)PutOption.DEFAULT), Op.get((ByteSequence)bucketKey, (GetOption)GetOption.DEFAULT)});
        ((CompletableFuture)txn.commit().thenAccept(txnResponse -> {
            if (txnResponse.getGetResponses().size() <= 0) {
                cb.operationComplete(-999, null);
            } else {
                GetResponse resp = (GetResponse)txnResponse.getGetResponses().get(0);
                if (resp.getCount() > 0L) {
                    KeyValue kv = (KeyValue)resp.getKvs().get(0);
                    if (kv.getVersion() > 0xFFFFFFFFFFFFFFL) {
                        log.warn("Etcd bucket '{}' is overflowed", (Object)bucketKey.toString(StandardCharsets.UTF_8));
                        this.generateLedgerId(cb);
                    } else {
                        long version = kv.getVersion();
                        long lid = (long)bucketId << 56 & 0xFF00000000000000L | version & 0xFFFFFFFFFFFFFFL;
                        cb.operationComplete(0, (Object)lid);
                    }
                } else {
                    cb.operationComplete(-999, null);
                }
            }
        })).exceptionally(cause -> {
            cb.operationComplete(-18, null);
            return null;
        });
    }

    public void close() {
    }
}

