/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd.helpers;

import java.util.function.Consumer;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;

public class RevisionedConsumer<T>
implements Consumer<Versioned<T>> {
    protected final Consumer<Versioned<T>> consumer;
    protected volatile Version localVersion = null;

    protected RevisionedConsumer(Consumer<Versioned<T>> consumer) {
        this.consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Versioned<T> versionedVal) {
        RevisionedConsumer revisionedConsumer = this;
        synchronized (revisionedConsumer) {
            if (this.localVersion != null && Version.Occurred.BEFORE != this.localVersion.compare(versionedVal.getVersion())) {
                return;
            }
            this.localVersion = versionedVal.getVersion();
        }
        this.consumer.accept(versionedVal);
    }

    public int hashCode() {
        return this.consumer.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Consumer)) {
            return false;
        }
        if (obj instanceof RevisionedConsumer) {
            return this.consumer.equals(((RevisionedConsumer)obj).consumer);
        }
        return this.consumer.equals(obj);
    }

    public String toString() {
        return this.consumer.toString();
    }
}

