/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd.helpers;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.metadata.etcd.helpers.KeyStream;

public class KeyIterator<T> {
    private final KeyStream<T> stream;
    private CompletableFuture<List<T>> readFuture = null;
    private boolean hasNext = true;
    private List<T> keys = null;

    public KeyIterator(KeyStream<T> stream) {
        this.stream = stream;
    }

    public synchronized boolean hasNext() throws Exception {
        if (this.hasNext) {
            if (null == this.readFuture) {
                this.readFuture = this.stream.readNext();
            }
            this.keys = (List)FutureUtils.result(this.readFuture);
            if (this.keys.isEmpty()) {
                this.hasNext = false;
            }
            return this.hasNext;
        }
        return false;
    }

    public synchronized List<T> next() throws Exception {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Reach end of key stream");
            }
            List<T> list = this.keys;
            return list;
        }
        finally {
            this.readFuture = this.stream.readNext();
        }
    }
}

