/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd.helpers;

import com.coreos.jetcd.KV;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.data.KeyValue;
import com.coreos.jetcd.options.GetOption;
import com.google.common.primitives.UnsignedBytes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStream<T> {
    private static final Logger log = LoggerFactory.getLogger(KeyStream.class);
    private final KV kvClient;
    private final ByteSequence startKey;
    private final ByteSequence endKey;
    private final Function<ByteSequence, T> encoder;
    private final int batchSize;
    private ByteSequence nextKey;
    private ByteSequence lastKey = null;
    private boolean hasMore = true;

    public KeyStream(KV kvClient, ByteSequence startKey, ByteSequence endKey, Function<ByteSequence, T> encoder) {
        this(kvClient, startKey, endKey, encoder, 100);
    }

    public KeyStream(KV kvClient, ByteSequence startKey, ByteSequence endKey, Function<ByteSequence, T> encoder, int batchSize) {
        this.kvClient = kvClient;
        this.startKey = startKey;
        this.endKey = endKey;
        this.nextKey = startKey;
        this.encoder = encoder;
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<T>> readNext() {
        ByteSequence beginKey;
        int batchSize = this.batchSize;
        KeyStream keyStream = this;
        synchronized (keyStream) {
            if (!this.hasMore) {
                return FutureUtils.value(Collections.emptyList());
            }
            beginKey = this.nextKey;
            if (null != this.lastKey) {
                ++batchSize;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Read keys between {} and {}", (Object)beginKey.toStringUtf8(), (Object)this.endKey.toStringUtf8());
        }
        return this.kvClient.get(beginKey, GetOption.newBuilder().withRange(this.endKey).withKeysOnly(true).withLimit((long)batchSize).withSortField(GetOption.SortTarget.KEY).withSortOrder(GetOption.SortOrder.ASCEND).build()).thenApply(getResp -> {
            ByteSequence lkey;
            List kvs = getResp.getKvs();
            KeyStream keyStream = this;
            synchronized (keyStream) {
                this.hasMore = getResp.isMore();
                lkey = this.lastKey;
                if (kvs.size() > 0) {
                    this.lastKey = this.nextKey = ((KeyValue)kvs.get(kvs.size() - 1)).getKey();
                }
            }
            if (null != lkey && kvs.size() > 0 && UnsignedBytes.lexicographicalComparator().compare(lkey.getBytes(), ((KeyValue)kvs.get(0)).getKey().getBytes()) == 0) {
                kvs.remove(0);
            }
            return kvs.stream().map(kv -> this.encoder.apply(kv.getKey())).collect(Collectors.toList());
        });
    }
}

