/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.data.ByteSequence;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.metadata.etcd.EtcdUtils;
import org.apache.bookkeeper.metadata.etcd.EtcdWatchClient;
import org.apache.bookkeeper.metadata.etcd.helpers.KeySetReader;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdRegistrationClient
implements RegistrationClient {
    private static final Logger log = LoggerFactory.getLogger(EtcdRegistrationClient.class);
    private final EtcdWatchClient watchClient;
    private final KeySetReader<BookieId> writableBookiesReader;
    private final KeySetReader<BookieId> readonlyBookiesReader;
    private Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieId>>>> writableListeners = Maps.newHashMap();
    private Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieId>>>> readonlyListeners = Maps.newHashMap();

    private static Function<ByteSequence, BookieId> newBookieSocketAddressFunc(String prefix) {
        return bs -> {
            String addrStr = bs.toStringUtf8();
            return BookieId.parse((String)addrStr.replace(prefix, ""));
        };
    }

    EtcdRegistrationClient(String scope, Client client) {
        this.watchClient = new EtcdWatchClient(client);
        this.writableBookiesReader = new KeySetReader<BookieId>(client, this.watchClient, EtcdRegistrationClient.newBookieSocketAddressFunc(EtcdUtils.getWritableBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getWritableBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getWritableBookiesEndPath(scope)));
        this.readonlyBookiesReader = new KeySetReader<BookieId>(client, this.watchClient, EtcdRegistrationClient.newBookieSocketAddressFunc(EtcdUtils.getReadonlyBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getReadonlyBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getReadonlyBookiesEndPath(scope)));
    }

    public void close() {
        this.writableBookiesReader.close();
        this.readonlyBookiesReader.close();
        this.watchClient.close();
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getWritableBookies() {
        return this.writableBookiesReader.read();
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getAllBookies() {
        return FutureUtils.exception((Throwable)new BKException.BKIllegalOpException());
    }

    public CompletableFuture<Versioned<Set<BookieId>>> getReadOnlyBookies() {
        return this.readonlyBookiesReader.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompletableFuture<Void> registerListener(KeySetReader<BookieId> keySetReader, Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieId>>>> listeners, RegistrationClient.RegistrationListener listener) {
        Consumer consumer;
        Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieId>>>> map = listeners;
        synchronized (map) {
            consumer = listeners.get(listener);
            if (null != consumer) {
                return FutureUtils.Void();
            }
            consumer = bookies -> listener.onBookiesChanged(bookies);
            listeners.put(listener, consumer);
        }
        return keySetReader.readAndWatch(consumer).thenApply(ignored -> null);
    }

    private static CompletableFuture<Void> unregisterListener(KeySetReader<BookieId> keySetReader, Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieId>>>> listeners, RegistrationClient.RegistrationListener listener) {
        Consumer consumer = listeners.get(listener);
        if (null == consumer) {
            return FutureUtils.Void();
        }
        return keySetReader.unwatch(consumer);
    }

    public CompletableFuture<Void> watchWritableBookies(RegistrationClient.RegistrationListener listener) {
        return EtcdRegistrationClient.registerListener(this.writableBookiesReader, this.writableListeners, listener);
    }

    public void unwatchWritableBookies(RegistrationClient.RegistrationListener listener) {
        EtcdRegistrationClient.unregisterListener(this.writableBookiesReader, this.writableListeners, listener);
    }

    public CompletableFuture<Void> watchReadOnlyBookies(RegistrationClient.RegistrationListener listener) {
        return EtcdRegistrationClient.registerListener(this.readonlyBookiesReader, this.readonlyListeners, listener);
    }

    public void unwatchReadOnlyBookies(RegistrationClient.RegistrationListener listener) {
        EtcdRegistrationClient.unregisterListener(this.readonlyBookiesReader, this.readonlyListeners, listener);
    }
}

