/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.api.WatchGrpc;
import com.coreos.jetcd.internal.impl.ClientConnectionManager;
import com.coreos.jetcd.internal.impl.ClientImpl;
import com.coreos.jetcd.internal.impl.EtcdClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(EtcdConnectionManager.class);
    private final ClientImpl client;
    private ClientConnectionManager connMgr;

    public EtcdConnectionManager(Client client) {
        this((ClientImpl)client);
    }

    EtcdConnectionManager(ClientImpl client) {
        this.client = client;
        try {
            this.connMgr = (ClientConnectionManager)EtcdClientUtils.getField(client, "connectionManager");
        }
        catch (NoSuchFieldException e) {
            log.error("No `connectionManager` field found in etcd client", (Throwable)e);
            throw new RuntimeException("No `connectionManager` field found in etcd client", e);
        }
        catch (IllegalAccessException e) {
            log.error("Illegal access to `connectionManager` field in etcd client", (Throwable)e);
            throw new RuntimeException("Illegal access to `connectionManager` field in etcd client", e);
        }
    }

    public WatchGrpc.WatchStub newWatchStub() {
        return (WatchGrpc.WatchStub)this.connMgr.newStub(WatchGrpc::newStub);
    }
}

