/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.versioning.Versioned;

class LedgerMetadataConsumer
implements Consumer<Versioned<LedgerMetadata>> {
    private final long ledgerId;
    private final BookkeeperInternalCallbacks.LedgerMetadataListener listener;
    private final Consumer<Long> onDeletedConsumer;

    LedgerMetadataConsumer(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener, Consumer<Long> onDeletedConsumer) {
        this.ledgerId = ledgerId;
        this.listener = listener;
        this.onDeletedConsumer = onDeletedConsumer;
    }

    public int hashCode() {
        return this.listener.hashCode();
    }

    public String toString() {
        return this.listener.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LedgerMetadataConsumer)) {
            return false;
        }
        LedgerMetadataConsumer another = (LedgerMetadataConsumer)obj;
        return this.ledgerId == another.ledgerId && Objects.equals(this.listener, another.listener) && Objects.equals(this.onDeletedConsumer, another.onDeletedConsumer);
    }

    @Override
    public void accept(Versioned<LedgerMetadata> ledgerMetadataVersioned) {
        if (null == ledgerMetadataVersioned.getValue()) {
            this.onDeletedConsumer.accept(this.ledgerId);
        } else {
            this.listener.onChanged(this.ledgerId, ledgerMetadataVersioned);
        }
    }
}

