/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.options.WatchOption;
import com.coreos.jetcd.watch.WatchResponse;
import com.coreos.jetcd.watch.WatchResponseWithError;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.metadata.etcd.EtcdWatchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdWatcher
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(EtcdWatcher.class);
    private final ScheduledExecutorService executor;
    private final WatchOption watchOption;
    private final ByteSequence key;
    private final CopyOnWriteArraySet<BiConsumer<WatchResponse, Throwable>> consumers;
    private long watchID;
    private long revision;
    private boolean closed = false;
    private final EtcdWatchClient owner;

    EtcdWatcher(ByteSequence key, WatchOption watchOption, ScheduledExecutorService executor, EtcdWatchClient owner) {
        this.key = key;
        this.watchOption = watchOption;
        this.executor = executor;
        this.owner = owner;
        this.consumers = new CopyOnWriteArraySet();
    }

    public void addConsumer(BiConsumer<WatchResponse, Throwable> consumer) {
        this.consumers.add(consumer);
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyWatchResponse(WatchResponseWithError watchResponse) {
        EtcdWatcher etcdWatcher = this;
        synchronized (etcdWatcher) {
            if (this.closed) {
                return;
            }
        }
        this.executor.submit(() -> this.consumers.forEach((Consumer<BiConsumer<WatchResponse, Throwable>>)((Consumer<BiConsumer>)c -> {
            if (watchResponse.getException() != null) {
                c.accept(null, watchResponse.getException());
            } else {
                c.accept(new WatchResponse(watchResponse.getWatchResponse()), null);
            }
        })));
    }

    public CompletableFuture<Void> closeAsync() {
        return this.owner.unwatch(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        EtcdWatcher etcdWatcher = this;
        synchronized (etcdWatcher) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            FutureUtils.result(this.closeAsync());
        }
        catch (Exception e) {
            log.warn("Encountered error on removing watcher '{}' from watch client : {}", (Object)this.watchID, (Object)e.getMessage());
        }
        this.consumers.clear();
    }

    public WatchOption getWatchOption() {
        return this.watchOption;
    }

    public ByteSequence getKey() {
        return this.key;
    }

    public long getWatchID() {
        return this.watchID;
    }

    public void setWatchID(long watchID) {
        this.watchID = watchID;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }
}

