/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.commons.lang3.StringUtils;

final class EtcdUtils {
    static String getScopeEndKey(String scope) {
        return String.format("%s%s", scope, "0");
    }

    static String getBucketsPath(String scope) {
        return String.format("%s/%s", scope, "buckets");
    }

    static String getBucketPath(String scope, int bucket) {
        return String.format("%s/%s/%03d", scope, "buckets", bucket);
    }

    static String getLayoutKey(String scope) {
        return String.format("%s/%s", scope, "layout");
    }

    static String getLedgersPath(String scope) {
        return String.format("%s/%s", scope, "ledgers");
    }

    static String getLedgerKey(String scope, long ledgerId) {
        return EtcdUtils.getLedgerKey(scope, 0L, ledgerId);
    }

    static String getLedgerKey(String scope, long scopeId, long ledgerId) {
        UUID uuid = new UUID(scopeId, ledgerId);
        return String.format("%s/ledgers/%s", scope, uuid.toString());
    }

    static UUID parseLedgerKey(String ledgerKey) {
        String[] keyParts = StringUtils.split((String)ledgerKey, (char)'/');
        return UUID.fromString(keyParts[keyParts.length - 1]);
    }

    static String getBookiesPath(String scope) {
        return String.format("%s/%s", scope, "bookies");
    }

    static String getBookiesEndPath(String scope) {
        return String.format("%s/%s%s", scope, "bookies", "0");
    }

    static String getWritableBookiesPath(String scope) {
        return String.format("%s/%s/%s", scope, "bookies", "writable");
    }

    static String getWritableBookiesBeginPath(String scope) {
        return String.format("%s/%s/%s/", scope, "bookies", "writable");
    }

    static String getWritableBookiesEndPath(String scope) {
        return String.format("%s/%s/%s%s", scope, "bookies", "writable", "0");
    }

    static String getWritableBookiePath(String scope, String bookieId) {
        return String.format("%s/%s/%s/%s", scope, "bookies", "writable", bookieId);
    }

    static String getReadonlyBookiesPath(String scope) {
        return String.format("%s/%s/%s", scope, "bookies", "readonly");
    }

    static String getReadonlyBookiesBeginPath(String scope) {
        return String.format("%s/%s/%s/", scope, "bookies", "readonly");
    }

    static String getReadonlyBookiesEndPath(String scope) {
        return String.format("%s/%s/%s%s", scope, "bookies", "readonly", "0");
    }

    static String getReadonlyBookiePath(String scope, String bookieId) {
        return String.format("%s/%s/%s/%s", scope, "bookies", "readonly", bookieId);
    }

    static String getCookiesPath(String scope) {
        return String.format("%s/%s", scope, "cookies");
    }

    static String getCookiePath(String scope, String bookieId) {
        return String.format("%s/%s/%s", scope, "cookies", bookieId);
    }

    static String getClusterInstanceIdPath(String scope) {
        return String.format("%s/%s", scope, "instanceid");
    }

    static String getUnderreplicationPath(String scope) {
        return String.format("%s/%s", scope, "underreplication");
    }

    static <T> T ioResult(CompletableFuture<T> future) throws IOException {
        return (T)FutureUtils.result(future, cause -> {
            if (cause instanceof IOException) {
                return (IOException)cause;
            }
            return new IOException((Throwable)cause);
        });
    }

    static <T> T msResult(CompletableFuture<T> future) throws BookieException.MetadataStoreException {
        return (T)FutureUtils.result(future, cause -> {
            if (cause instanceof BookieException.MetadataStoreException) {
                return (BookieException.MetadataStoreException)cause;
            }
            return new BookieException.MetadataStoreException(cause);
        });
    }

    static <T> T msResult(CompletableFuture<T> future, long timeout, TimeUnit timeUnit) throws BookieException.MetadataStoreException, TimeoutException {
        return (T)FutureUtils.result(future, cause -> {
            if (cause instanceof BookieException.MetadataStoreException) {
                return (BookieException.MetadataStoreException)cause;
            }
            return new BookieException.MetadataStoreException(cause);
        }, (long)timeout, (TimeUnit)timeUnit);
    }

    public static long toLong(byte[] memory, int index) {
        return ((long)memory[index] & 0xFFL) << 56 | ((long)memory[index + 1] & 0xFFL) << 48 | ((long)memory[index + 2] & 0xFFL) << 40 | ((long)memory[index + 3] & 0xFFL) << 32 | ((long)memory[index + 4] & 0xFFL) << 24 | ((long)memory[index + 5] & 0xFFL) << 16 | ((long)memory[index + 6] & 0xFFL) << 8 | (long)memory[index + 7] & 0xFFL;
    }

    public static byte[] toBytes(long value) {
        byte[] memory = new byte[8];
        EtcdUtils.toBytes(value, memory, 0);
        return memory;
    }

    public static void toBytes(long value, byte[] memory, int index) {
        memory[index] = (byte)(value >>> 56);
        memory[index + 1] = (byte)(value >>> 48);
        memory[index + 2] = (byte)(value >>> 40);
        memory[index + 3] = (byte)(value >>> 32);
        memory[index + 4] = (byte)(value >>> 24);
        memory[index + 5] = (byte)(value >>> 16);
        memory[index + 6] = (byte)(value >>> 8);
        memory[index + 7] = (byte)value;
    }

    private EtcdUtils() {
    }
}

