/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metadata.etcd;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.data.ByteSequence;
import com.google.common.collect.Maps;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.metadata.etcd.EtcdUtils;
import org.apache.bookkeeper.metadata.etcd.EtcdWatchClient;
import org.apache.bookkeeper.metadata.etcd.helpers.KeySetReader;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdRegistrationClient
implements RegistrationClient {
    private static final Logger log = LoggerFactory.getLogger(EtcdRegistrationClient.class);
    private final EtcdWatchClient watchClient;
    private final KeySetReader<BookieSocketAddress> writableBookiesReader;
    private final KeySetReader<BookieSocketAddress> readonlyBookiesReader;
    private Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieSocketAddress>>>> writableListeners = Maps.newHashMap();
    private Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieSocketAddress>>>> readonlyListeners = Maps.newHashMap();

    private static Function<ByteSequence, BookieSocketAddress> newBookieSocketAddressFunc(String prefix) {
        return bs -> {
            String addrStr = bs.toStringUtf8();
            try {
                return new BookieSocketAddress(addrStr.replace(prefix, ""));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Unknown bookie address '" + addrStr + "' : ", e);
            }
        };
    }

    EtcdRegistrationClient(String scope, Client client) {
        this.watchClient = new EtcdWatchClient(client);
        this.writableBookiesReader = new KeySetReader<BookieSocketAddress>(client, this.watchClient, EtcdRegistrationClient.newBookieSocketAddressFunc(EtcdUtils.getWritableBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getWritableBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getWritableBookiesEndPath(scope)));
        this.readonlyBookiesReader = new KeySetReader<BookieSocketAddress>(client, this.watchClient, EtcdRegistrationClient.newBookieSocketAddressFunc(EtcdUtils.getReadonlyBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getReadonlyBookiesBeginPath(scope)), ByteSequence.fromString((String)EtcdUtils.getReadonlyBookiesEndPath(scope)));
    }

    public void close() {
        this.writableBookiesReader.close();
        this.readonlyBookiesReader.close();
        this.watchClient.close();
    }

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getWritableBookies() {
        return this.writableBookiesReader.read();
    }

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getAllBookies() {
        return FutureUtils.exception((Throwable)new BKException.BKIllegalOpException());
    }

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getReadOnlyBookies() {
        return this.readonlyBookiesReader.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompletableFuture<Void> registerListener(KeySetReader<BookieSocketAddress> keySetReader, Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieSocketAddress>>>> listeners, RegistrationClient.RegistrationListener listener) {
        Consumer consumer;
        Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieSocketAddress>>>> map = listeners;
        synchronized (map) {
            consumer = listeners.get(listener);
            if (null != consumer) {
                return FutureUtils.Void();
            }
            consumer = bookies -> listener.onBookiesChanged(bookies);
            listeners.put(listener, consumer);
        }
        return keySetReader.readAndWatch(consumer).thenApply(ignored -> null);
    }

    private static CompletableFuture<Void> unregisterListener(KeySetReader<BookieSocketAddress> keySetReader, Map<RegistrationClient.RegistrationListener, Consumer<Versioned<Set<BookieSocketAddress>>>> listeners, RegistrationClient.RegistrationListener listener) {
        Consumer consumer = listeners.get(listener);
        if (null == consumer) {
            return FutureUtils.Void();
        }
        return keySetReader.unwatch(consumer);
    }

    public CompletableFuture<Void> watchWritableBookies(RegistrationClient.RegistrationListener listener) {
        return EtcdRegistrationClient.registerListener(this.writableBookiesReader, this.writableListeners, listener);
    }

    public void unwatchWritableBookies(RegistrationClient.RegistrationListener listener) {
        EtcdRegistrationClient.unregisterListener(this.writableBookiesReader, this.writableListeners, listener);
    }

    public CompletableFuture<Void> watchReadOnlyBookies(RegistrationClient.RegistrationListener listener) {
        return EtcdRegistrationClient.registerListener(this.readonlyBookiesReader, this.readonlyListeners, listener);
    }

    public void unwatchReadOnlyBookies(RegistrationClient.RegistrationListener listener) {
        EtcdRegistrationClient.unregisterListener(this.readonlyBookiesReader, this.readonlyListeners, listener);
    }
}

