/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.util;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.util.Callback;
import org.slf4j.Logger;

public class CallbackUtils {
    private static Callback<Void> nop = new Callback<Void>(){

        @Override
        public void operationFailed(Object ctx, PubSubException exception) {
        }

        @Override
        public void operationFinished(Object ctx, Void resultOfOperation) {
        }
    };

    public static Callback<Void> multiCallback(final int expected, final Callback<Void> cb, final Object ctx, final Logger logger, final String successMsg, final String failureMsg, Runnable eagerErrorHandler) {
        if (expected == 0) {
            cb.operationFinished(ctx, null);
            return null;
        }
        return new Callback<Void>(){
            final AtomicInteger done = new AtomicInteger();
            final LinkedBlockingQueue<PubSubException> exceptions = new LinkedBlockingQueue();

            private void tick() {
                if (this.done.incrementAndGet() == expected) {
                    if (this.exceptions.isEmpty()) {
                        cb.operationFinished(ctx, null);
                    } else {
                        cb.operationFailed(ctx, (PubSubException)new PubSubException.CompositeException(this.exceptions));
                    }
                }
            }

            @Override
            public void operationFailed(Object ctx2, PubSubException exception) {
                if (logger != null && failureMsg != null) {
                    logger.error(failureMsg, (Throwable)exception);
                }
                this.exceptions.add(exception);
                this.tick();
            }

            @Override
            public void operationFinished(Object ctx2, Void resultOfOperation) {
                if (logger != null && successMsg != null) {
                    logger.info(successMsg);
                }
                this.tick();
            }
        };
    }

    public static Callback<Void> multiCallback(int expected, Callback<Void> cb, Object ctx) {
        return CallbackUtils.multiCallback(expected, cb, ctx, null, null, null, null);
    }

    public static Callback<Void> multinCallback(int expected, Callback<Void> cb, Object ctx, Runnable eagerErrorHandler) {
        return CallbackUtils.multiCallback(expected, cb, ctx, null, null, null, eagerErrorHandler);
    }

    public static Callback<Void> nop() {
        return nop;
    }

    public static <T> Callback<T> logger(final Logger logger, final String successMsg, final String failureMsg, final Callback<T> cont) {
        return new Callback<T>(){

            @Override
            public void operationFailed(Object ctx, PubSubException exception) {
                logger.error(failureMsg, (Throwable)exception);
                if (cont != null) {
                    cont.operationFailed(ctx, exception);
                }
            }

            @Override
            public void operationFinished(Object ctx, T resultOfOperation) {
                logger.info(successMsg);
                if (cont != null) {
                    cont.operationFinished(ctx, resultOfOperation);
                }
            }
        };
    }

    public static Callback<Void> logger(Logger logger, String successMsg, String failureMsg) {
        return CallbackUtils.logger(logger, successMsg, failureMsg, CallbackUtils.nop());
    }

    public static <T> Callback<Void> curry(final Callback<T> cb, final T result) {
        return new Callback<Void>(){

            @Override
            public void operationFailed(Object ctx, PubSubException exception) {
                cb.operationFailed(ctx, exception);
            }

            @Override
            public void operationFinished(Object ctx, Void resultOfOperation) {
                cb.operationFinished(ctx, result);
            }
        };
    }
}

