/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public abstract class SslContextFactory {
    protected SSLContext ctx;

    public SSLContext getContext() {
        return this.ctx;
    }

    protected abstract boolean isClient();

    public SSLEngine getEngine() {
        SSLEngine engine = this.ctx.createSSLEngine();
        engine.setUseClientMode(this.isClient());
        return engine;
    }

    protected TrustManager[] getTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
    }
}

