/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import java.net.InetSocketAddress;
import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.client.data.TopicSubscriber;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.jboss.netty.channel.Channel;

public class NetUtils {
    public static InetSocketAddress getHostFromChannel(Channel channel) {
        return (InetSocketAddress)channel.getRemoteAddress();
    }

    public static PubSubProtocol.PubSubRequest.Builder buildPubSubRequest(long txnId, PubSubData pubSubData) {
        PubSubProtocol.PubSubRequest.Builder pubsubRequestBuilder = PubSubProtocol.PubSubRequest.newBuilder();
        pubsubRequestBuilder.setProtocolVersion(PubSubProtocol.ProtocolVersion.VERSION_ONE);
        pubsubRequestBuilder.setType(pubSubData.operationType);
        if (PubSubProtocol.OperationType.CONSUME != pubSubData.operationType && pubSubData.triedServers != null && pubSubData.triedServers.size() > 0) {
            pubsubRequestBuilder.addAllTriedServers(pubSubData.triedServers);
        }
        pubsubRequestBuilder.setTxnId(txnId);
        pubsubRequestBuilder.setShouldClaim(pubSubData.shouldClaim);
        pubsubRequestBuilder.setTopic(pubSubData.topic);
        switch (pubSubData.operationType) {
            case PUBLISH: {
                pubsubRequestBuilder.setPublishRequest(NetUtils.buildPublishRequest(pubSubData));
                break;
            }
            case SUBSCRIBE: {
                pubsubRequestBuilder.setSubscribeRequest(NetUtils.buildSubscribeRequest(pubSubData));
                break;
            }
            case UNSUBSCRIBE: {
                pubsubRequestBuilder.setUnsubscribeRequest(NetUtils.buildUnsubscribeRequest(pubSubData));
                break;
            }
            case CLOSESUBSCRIPTION: {
                pubsubRequestBuilder.setCloseSubscriptionRequest(NetUtils.buildCloseSubscriptionRequest(pubSubData));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown argument type " + pubSubData.operationType);
            }
        }
        pubSubData.txnId = txnId;
        pubSubData.requestWriteTime = System.currentTimeMillis();
        return pubsubRequestBuilder;
    }

    private static PubSubProtocol.PublishRequest.Builder buildPublishRequest(PubSubData pubSubData) {
        PubSubProtocol.PublishRequest.Builder publishRequestBuilder = PubSubProtocol.PublishRequest.newBuilder();
        publishRequestBuilder.setMsg(pubSubData.msg);
        return publishRequestBuilder;
    }

    private static PubSubProtocol.SubscribeRequest.Builder buildSubscribeRequest(PubSubData pubSubData) {
        PubSubProtocol.SubscribeRequest.Builder subscribeRequestBuilder = PubSubProtocol.SubscribeRequest.newBuilder();
        subscribeRequestBuilder.setSubscriberId(pubSubData.subscriberId);
        subscribeRequestBuilder.setCreateOrAttach(pubSubData.options.getCreateOrAttach());
        subscribeRequestBuilder.setForceAttach(pubSubData.options.getForceAttach());
        subscribeRequestBuilder.setSynchronous(true);
        PubSubProtocol.SubscriptionPreferences.Builder preferencesBuilder = NetUtils.options2Preferences(pubSubData.options);
        if (preferencesBuilder.hasMessageBound()) {
            subscribeRequestBuilder.setMessageBound(preferencesBuilder.getMessageBound());
        }
        subscribeRequestBuilder.setPreferences(preferencesBuilder);
        return subscribeRequestBuilder;
    }

    private static PubSubProtocol.UnsubscribeRequest.Builder buildUnsubscribeRequest(PubSubData pubSubData) {
        PubSubProtocol.UnsubscribeRequest.Builder unsubscribeRequestBuilder = PubSubProtocol.UnsubscribeRequest.newBuilder();
        unsubscribeRequestBuilder.setSubscriberId(pubSubData.subscriberId);
        return unsubscribeRequestBuilder;
    }

    private static PubSubProtocol.CloseSubscriptionRequest.Builder buildCloseSubscriptionRequest(PubSubData pubSubData) {
        PubSubProtocol.CloseSubscriptionRequest.Builder closeSubscriptionRequestBuilder = PubSubProtocol.CloseSubscriptionRequest.newBuilder();
        closeSubscriptionRequestBuilder.setSubscriberId(pubSubData.subscriberId);
        return closeSubscriptionRequestBuilder;
    }

    public static PubSubProtocol.PubSubRequest.Builder buildConsumeRequest(long txnId, TopicSubscriber topicSubscriber, PubSubProtocol.MessageSeqId messageSeqId) {
        PubSubProtocol.PubSubRequest.Builder pubsubRequestBuilder = PubSubProtocol.PubSubRequest.newBuilder();
        pubsubRequestBuilder.setProtocolVersion(PubSubProtocol.ProtocolVersion.VERSION_ONE);
        pubsubRequestBuilder.setType(PubSubProtocol.OperationType.CONSUME);
        pubsubRequestBuilder.setTxnId(txnId);
        pubsubRequestBuilder.setTopic(topicSubscriber.getTopic());
        PubSubProtocol.ConsumeRequest.Builder consumeRequestBuilder = PubSubProtocol.ConsumeRequest.newBuilder();
        consumeRequestBuilder.setSubscriberId(topicSubscriber.getSubscriberId());
        consumeRequestBuilder.setMsgId(messageSeqId);
        pubsubRequestBuilder.setConsumeRequest(consumeRequestBuilder);
        return pubsubRequestBuilder;
    }

    private static PubSubProtocol.SubscriptionPreferences.Builder options2Preferences(PubSubProtocol.SubscriptionOptions options) {
        PubSubProtocol.SubscriptionPreferences.Builder preferencesBuilder = PubSubProtocol.SubscriptionPreferences.newBuilder();
        if (options.getMessageBound() > 0) {
            preferencesBuilder.setMessageBound(options.getMessageBound());
        }
        if (options.hasMessageFilter()) {
            preferencesBuilder.setMessageFilter(options.getMessageFilter());
        }
        if (options.hasOptions()) {
            preferencesBuilder.setOptions(options.getOptions());
        }
        if (options.hasMessageWindowSize() && options.getMessageWindowSize() > 0) {
            preferencesBuilder.setMessageWindowSize(options.getMessageWindowSize());
        }
        return preferencesBuilder;
    }
}

