/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.netty;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hedwig.client.api.Client;
import org.apache.hedwig.client.conf.ClientConfiguration;
import org.apache.hedwig.client.netty.HChannelManager;
import org.apache.hedwig.client.netty.HedwigPublisher;
import org.apache.hedwig.client.netty.HedwigSubscriber;
import org.apache.hedwig.client.netty.impl.multiplex.MultiplexHChannelManager;
import org.apache.hedwig.client.netty.impl.simple.SimpleHChannelManager;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HedwigClientImpl
implements Client {
    private static final Logger logger = LoggerFactory.getLogger(HedwigClientImpl.class);
    protected final ChannelFactory socketFactory;
    protected boolean ownChannelFactory = false;
    protected final HChannelManager channelManager;
    private HedwigSubscriber sub;
    private final HedwigPublisher pub;
    private final ClientConfiguration cfg;

    public static Client create(ClientConfiguration cfg) {
        return new HedwigClientImpl(cfg);
    }

    public static Client create(ClientConfiguration cfg, ChannelFactory socketFactory) {
        return new HedwigClientImpl(cfg, socketFactory);
    }

    protected HedwigClientImpl(ClientConfiguration cfg) {
        this(cfg, (ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("HedwigClient-NIOBoss-%d").build()), (Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("HedwigClient-NIOWorker-%d").build())));
        this.ownChannelFactory = true;
    }

    protected HedwigClientImpl(ClientConfiguration cfg, ChannelFactory socketFactory) {
        this.cfg = cfg;
        this.socketFactory = socketFactory;
        this.channelManager = cfg.isSubscriptionChannelSharingEnabled() ? new MultiplexHChannelManager(cfg, socketFactory) : new SimpleHChannelManager(cfg, socketFactory);
        this.pub = new HedwigPublisher(this);
        this.sub = new HedwigSubscriber(this);
    }

    public ClientConfiguration getConfiguration() {
        return this.cfg;
    }

    public HChannelManager getHChannelManager() {
        return this.channelManager;
    }

    @Override
    public HedwigSubscriber getSubscriber() {
        return this.sub;
    }

    protected void setSubscriber(HedwigSubscriber sub) {
        this.sub = sub;
    }

    @Override
    public HedwigPublisher getPublisher() {
        return this.pub;
    }

    @Override
    public void close() {
        logger.info("Stopping the client!");
        this.channelManager.close();
        if (this.ownChannelFactory) {
            this.socketFactory.releaseExternalResources();
        }
        logger.info("Completed stopping the client!");
    }
}

