/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hedwig.client.handlers;

import org.apache.hedwig.client.data.PubSubData;
import org.apache.hedwig.exceptions.PubSubException;
import org.apache.hedwig.protocol.PubSubProtocol;
import org.apache.hedwig.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubCallback
implements Callback<PubSubProtocol.ResponseBody> {
    private static Logger logger = LoggerFactory.getLogger(PubSubCallback.class);
    private final PubSubData pubSubData;
    private boolean isCallSuccessful;
    private PubSubException failureException;
    private PubSubProtocol.ResponseBody responseBody;

    public PubSubCallback(PubSubData pubSubData) {
        this.pubSubData = pubSubData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationFinished(Object ctx, PubSubProtocol.ResponseBody resultOfOperation) {
        logger.debug("PubSub call succeeded for pubSubData: {}", (Object)this.pubSubData);
        PubSubData pubSubData = this.pubSubData;
        synchronized (pubSubData) {
            this.responseBody = resultOfOperation;
            this.isCallSuccessful = true;
            this.pubSubData.isDone = true;
            this.pubSubData.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationFailed(Object ctx, PubSubException exception) {
        logger.debug("PubSub call failed with exception: {}, pubSubData: {}", (Object)exception, (Object)this.pubSubData);
        PubSubData pubSubData = this.pubSubData;
        synchronized (pubSubData) {
            this.isCallSuccessful = false;
            this.failureException = exception;
            this.pubSubData.isDone = true;
            this.pubSubData.notify();
        }
    }

    public boolean getIsCallSuccessful() {
        return this.isCallSuccessful;
    }

    public PubSubException getFailureException() {
        return this.failureException;
    }

    public PubSubProtocol.ResponseBody getResponseBody() {
        return this.responseBody;
    }
}

